/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.input.StringSlurper;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import picocli.CommandLine;

@CommandLine.Command(name="classpath", description={"Resolves Maven Artifact and prints out the classpath"})
@Mojo(name="gav-classpath", requiresProject=false, threadSafe=true)
public class GavClasspathMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The GAV to print classpath for"})
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--scope"}, defaultValue="runtime", description={"Resolution scope to resolve (default 'runtime')"})
    @Parameter(property="scope", defaultValue="runtime", required=true)
    private String scope;
    @CommandLine.Option(names={"--boms"}, defaultValue="", description={"Comma separated list of BOMs to apply"})
    @Parameter(property="boms")
    private String boms;

    protected Result<String> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.classpath(ResolutionScope.parse((String)this.scope), toolboxCommando.loadGavs(StringSlurper.slurp((String)this.gav), StringSlurper.slurp((String)this.boms)));
    }
}

