/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.input.StringSlurper;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.collection.CollectResult;
import picocli.CommandLine;

@CommandLine.Command(name="dm-tree", description={"Displays dependency management tree of Maven Artifact"})
@Mojo(name="gav-dm-tree", requiresProject=false, threadSafe=true)
public class GavDmTreeMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The GAV to show dependency management tree for"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--boms"}, defaultValue="", description={"Comma separated list of BOMs to apply"})
    @Parameter(property="boms")
    private String boms;
    @CommandLine.Option(names={"--verboseTree"}, defaultValue="false", description={"Make it true for verbose tree"})
    @Parameter(property="verboseTree", defaultValue="false", required=true)
    private boolean verboseTree;

    protected Result<CollectResult> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.dmTree(toolboxCommando.loadGav(this.gav, StringSlurper.slurp((String)this.boms)), this.verboseTree);
    }
}

