/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import org.apache.maven.model.Model;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import picocli.CommandLine;

@CommandLine.Command(name="effective-model", description={"Shows model of Maven Artifact"})
@Mojo(name="gav-effective-model", requiresProject=false, threadSafe=true)
public class GavEffectiveModelMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The GAV to check for"})
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--verbose"}, description={"Whether to output verbose model or not."})
    @Parameter(property="verbose", defaultValue="false", required=true)
    private boolean verbose;

    protected Result<Model> doExecute() throws Exception {
        Model model;
        Result modelString;
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        Result result = toolboxCommando.effectiveModel(toolboxCommando.loadGav(this.gav));
        if (result.isSuccess() && (modelString = toolboxCommando.modelToString(model = (Model)result.getData().orElseThrow(), this.verbose)).isSuccess()) {
            this.getOutput().tell((String)modelString.getData().orElseThrow(), new Object[0]);
        }
        return result;
    }
}

