/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import org.apache.maven.model.Model;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import picocli.CommandLine;

@CommandLine.Command(name="flatten-bom", description={"Flattens a BOM"})
@Mojo(name="gav-flatten-bom", requiresProject=false, threadSafe=true)
public class GavFlattenBomMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", defaultValue="org.acme:acme:1.0", description={"The GAV to emit flattened BOM with"})
    @Parameter(property="gav", defaultValue="org.acme:acme:1.0")
    private String gav;
    @CommandLine.Parameters(index="0", description={"The GAV of BOM to flatten"})
    @Parameter(property="bom", required=true)
    private String bom;
    @CommandLine.Option(names={"--verbose"}, description={"Whether to output verbose model or not."})
    @Parameter(property="verbose", defaultValue="false", required=true)
    private boolean verbose;

    protected Result<Model> doExecute() throws Exception {
        Model model;
        Result modelString;
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        Result result = toolboxCommando.flattenBOM((Artifact)new DefaultArtifact(this.gav), toolboxCommando.loadGav(this.bom));
        if (result.isSuccess() && (modelString = toolboxCommando.modelToString(model = (Model)result.getData().orElseThrow(), this.verbose)).isSuccess()) {
            this.getOutput().tell((String)modelString.getData().orElseThrow(), new Object[0]);
        }
        return result;
    }
}

