/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.input.StringSlurper;
import java.io.File;
import java.util.List;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import picocli.CommandLine;

@CommandLine.Command(name="list-available-plugins", description={"List available plugins for given Gs"})
@Mojo(name="gav-list-available-plugins", requiresProject=false, threadSafe=true)
public class GavListAvailablePluginsMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", defaultValue="org.apache.maven.plugins,org.codehaus.mojo", description={"The comma separated GroupIDs to list"}, arity="1")
    @Parameter(property="groupIds")
    private String groupIds;
    @CommandLine.Option(names={"--toPom"}, description={"Output it into given POM"})
    @Parameter(property="toPom")
    private File toPom;
    @CommandLine.Option(names={"--upsert"}, description={"Whether to update existing only, or upsert"})
    @Parameter(property="upsert")
    private boolean upsert;

    protected Result<List<Artifact>> doExecute() throws Exception {
        Result result;
        if (this.groupIds == null || this.groupIds.trim().isEmpty()) {
            this.groupIds = String.join((CharSequence)",", this.mojoSettings.getPluginGroups());
        }
        if ((result = this.getToolboxCommando().listAvailablePlugins(StringSlurper.csv((String)this.groupIds))).isSuccess() && this.toPom != null) {
            try (ToolboxCommando.EditSession es = this.getToolboxCommando().createEditSession(this.toPom.toPath());){
                Result result2 = this.getToolboxCommando().editPom(es, ToolboxCommando.PomOpSubject.MANAGED_PLUGINS, this.upsert ? ToolboxCommando.Op.UPSERT : ToolboxCommando.Op.UPDATE, () -> ((List)result.getData().orElseThrow()).stream());
                return result2;
            }
        }
        return result;
    }
}

