/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.input.StringSlurper;
import java.util.List;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import picocli.CommandLine;

@CommandLine.Command(name="resolve", description={"Resolves Maven Artifacts"})
@Mojo(name="gav-resolve", requiresProject=false, threadSafe=true)
public class GavResolveMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The comma separated GAVs to resolve"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--sources"}, description={"Resolve sources JAR as well (derive coordinates from GAV)"})
    @Parameter(property="sources", defaultValue="false")
    private boolean sources;
    @CommandLine.Option(names={"--javadoc"}, description={"Resolve javadoc JAR as well (derive coordinates from GAV)"})
    @Parameter(property="javadoc", defaultValue="false")
    private boolean javadoc;
    @CommandLine.Option(names={"--signature"}, description={"Resolve GnuPG signature as well (derive coordinates from GAV)"})
    @Parameter(property="signature", defaultValue="false")
    private boolean signature;
    @CommandLine.Option(names={"--sinkSpec"}, defaultValue="null()", description={"The sink spec (default 'null()')"})
    @Parameter(property="sinkSpec", defaultValue="null()", required=true)
    private String sinkSpec;

    protected Result<List<Artifact>> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.resolve(() -> StringSlurper.slurp((String)this.gav).stream().map(DefaultArtifact::new), this.sources, this.javadoc, this.signature, toolboxCommando.artifactSink(this.sinkSpec, this.dryRun));
    }
}

