/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.input.StringSlurper;
import java.util.Map;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.collection.CollectResult;
import picocli.CommandLine;

@CommandLine.Command(name="tree-diff", description={"Displays dependency tree differences of two Maven Artifact"})
@Mojo(name="gav-tree-diff", requiresProject=false, threadSafe=true)
public class GavTreeDiffMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The first GAV to show tree for"}, arity="1")
    @Parameter(property="gav1", required=true)
    private String gav1;
    @CommandLine.Parameters(index="1", description={"The second GAV to show tree for"}, arity="1")
    @Parameter(property="gav2", required=true)
    private String gav2;
    @CommandLine.Option(names={"--scope"}, defaultValue="runtime", description={"Resolution scope to resolve (default 'runtime')"})
    @Parameter(property="scope", defaultValue="runtime", required=true)
    private String scope;
    @CommandLine.Option(names={"--boms"}, defaultValue="", description={"Comma separated list of BOMs to apply"})
    @Parameter(property="boms")
    private String boms;
    @CommandLine.Option(names={"--dependencyMatcher"}, defaultValue="any()", description={"Dependency matcher spec"})
    @Parameter(property="dependencyMatcher", defaultValue="any()", required=true)
    private String dependencyMatcher;
    @CommandLine.Option(names={"--verboseTree"}, defaultValue="false", description={"Make it true for verbose tree"})
    @Parameter(property="verboseTree", defaultValue="false", required=true)
    private boolean verboseTree;

    protected Result<Map<CollectResult, CollectResult>> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.treeDiff(ResolutionScope.parse((String)this.scope), toolboxCommando.loadGav(this.gav1, StringSlurper.slurp((String)this.boms)), toolboxCommando.loadGav(this.gav2, StringSlurper.slurp((String)this.boms)), this.verboseTree, toolboxCommando.parseDependencyMatcherSpec(this.dependencyMatcher));
    }
}

