/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.input.StringSlurper;
import java.util.List;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import picocli.CommandLine;

@CommandLine.Command(name="tree-find", description={"Collects and displays paths to matched artifacts in tree, if exists"})
@Mojo(name="gav-tree-find", requiresProject=false, threadSafe=true)
public class GavTreeFindMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The GAV to show tree for"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Parameters(index="1", description={"The artifact to show paths for"}, arity="1")
    @Parameter(property="artifactMatcherSpec", required=true)
    private String artifactMatcherSpec;
    @CommandLine.Option(names={"--scope"}, defaultValue="runtime", description={"Resolution scope to resolve (default 'runtime')"})
    @Parameter(property="scope", defaultValue="runtime", required=true)
    private String scope;
    @CommandLine.Option(names={"--boms"}, defaultValue="", description={"Comma separated list of BOMs to apply"})
    @Parameter(property="boms")
    private String boms;
    @CommandLine.Option(names={"--verboseTree"}, defaultValue="false", description={"Make it true for verbose tree"})
    @Parameter(property="verboseTree", defaultValue="false", required=true)
    private boolean verboseTree;

    protected Result<List<List<Artifact>>> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.treeFind(ResolutionScope.parse((String)this.scope), toolboxCommando.loadGav(this.gav, StringSlurper.slurp((String)this.boms)), this.verboseTree, toolboxCommando.parseArtifactMatcherSpec(this.artifactMatcherSpec));
    }
}

