/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.hello;

import eu.maveniverse.maven.toolbox.plugin.hello.HelloProjectMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import picocli.CommandLine;

@CommandLine.Command(name="add-core-extension", description={"Adds core extension"})
@Mojo(name="add-core-extension", requiresProject=false, threadSafe=true)
public class AddCoreExtension
extends HelloProjectMojoSupport {
    @CommandLine.Parameters(index="0", description={"The extension GAV"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"scope"}, defaultValue="project", description={"The scope where to look."})
    @Parameter(property="scope", defaultValue="project")
    private String scope;

    protected Result<Boolean> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        Artifact extension = this.toCoreExtensionArtifact(this.gav);
        ToolboxCommando.ExtensionsScope extensionsScope = ToolboxCommando.ExtensionsScope.valueOf((String)this.scope.toUpperCase(Locale.ROOT));
        Path extensionsXml = extensionsScope == ToolboxCommando.ExtensionsScope.PROJECT ? this.getRootPom().getParent().resolve(".mvn").resolve("extensions.xml") : toolboxCommando.extensionsPath(extensionsScope);
        try (ToolboxCommando.EditSession editSession = this.getToolboxCommando().createEditSession(extensionsXml);){
            toolboxCommando.editExtensions(editSession, ToolboxCommando.Op.UPSERT, List.of(extension)::stream);
        }
        return Result.success((Object)Boolean.TRUE);
    }
}

