/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.hello;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionSelector;
import eu.maveniverse.maven.toolbox.shared.Result;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import picocli.CommandLine;

public abstract class HelloMojoSupport
extends GavMojoSupport {
    @CommandLine.Option(names={"--parentVersionMatcherSpec"}, defaultValue="noSnapshotsAndPreviews()", description={"Artifact version matcher spec for parent (default 'noSnapshotsAndPreviews()')"})
    @Parameter(property="parentVersionMatcherSpec", defaultValue="noSnapshotsAndPreviews()")
    protected String parentVersionMatcherSpec;
    @CommandLine.Option(names={"--artifactVersionSelectorSpec"}, defaultValue="last()", description={"Artifact version selector spec (default 'last()')"})
    @Parameter(property="artifactVersionSelectorSpec", defaultValue="last()")
    protected String parentVersionSelectorSpec;
    @CommandLine.Option(names={"--force"}, description={"Force overwrite of existing POM file"})
    @Parameter(property="force")
    protected boolean force;

    protected Path getRootPom() {
        return this.resolve(Path.of("pom.xml", new String[0]));
    }

    protected Artifact toRootProjectArtifact(String gav) throws Exception {
        try {
            return new DefaultArtifact(gav).setFile(this.getRootPom().toFile());
        }
        catch (IllegalArgumentException ex) {
            return new DefaultArtifact(gav + ":1.0.0-SNAPSHOT").setFile(this.getRootPom().toFile());
        }
    }

    private Artifact toLatestArtifact(String gav) throws Exception {
        if (gav == null) {
            return null;
        }
        try {
            return new DefaultArtifact((String)gav);
        }
        catch (IllegalArgumentException e) {
            gav = (String)gav + ":0";
            DefaultArtifact artifact = new DefaultArtifact((String)gav);
            ArtifactVersionMatcher artifactVersionMatcher = this.getToolboxCommando().parseArtifactVersionMatcherSpec(this.parentVersionMatcherSpec);
            ArtifactVersionSelector artifactVersionSelector = this.getToolboxCommando().parseArtifactVersionSelectorSpec(this.parentVersionSelectorSpec);
            Result versions = this.getToolboxCommando().versions("hello", () -> HelloMojoSupport.lambda$toLatestArtifact$0((Artifact)artifact), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
            if (versions.isSuccess()) {
                List parentArtifacts = this.getToolboxCommando().calculateUpdates((Map)versions.getData().orElseThrow(), (BiFunction)artifactVersionSelector);
                if (parentArtifacts.isEmpty()) {
                    throw new IllegalStateException("No parent artifacts found for " + (String)gav);
                }
                return (Artifact)parentArtifacts.get(0);
            }
            throw new IllegalStateException("Could not select latest version of parent " + String.valueOf(artifact));
        }
    }

    protected Artifact toParentArtifact(String gav) throws Exception {
        return this.toLatestArtifact(gav);
    }

    protected Artifact toDependencyArtifact(String gav) throws Exception {
        return this.toLatestArtifact(gav);
    }

    protected Artifact toPluginArtifact(String gav) throws Exception {
        return this.toLatestArtifact(gav);
    }

    protected Artifact toCoreExtensionArtifact(String gav) throws Exception {
        return this.toLatestArtifact(gav);
    }

    private static /* synthetic */ Stream lambda$toLatestArtifact$0(Artifact artifact) throws IOException {
        return Stream.of(artifact);
    }
}

