/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.hello;

import eu.maveniverse.maven.toolbox.plugin.hello.HelloMojoSupport;
import eu.maveniverse.maven.toolbox.shared.internal.domtrip.DOMTripUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public abstract class HelloProjectMojoSupport
extends HelloMojoSupport {
    protected Artifact getCurrentProjectArtifact() {
        if (!Files.exists(this.getRootPom(), new LinkOption[0])) {
            throw new IllegalStateException("This directory does not contain pom.xml");
        }
        return DOMTripUtils.fromPom((Path)this.getRootPom());
    }

    protected Artifact toSubProjectArtifact(String gav) {
        DefaultArtifact result;
        Artifact currentProjectArtifact = this.getCurrentProjectArtifact();
        try {
            result = new DefaultArtifact(gav);
        }
        catch (IllegalArgumentException ex) {
            try {
                result = new DefaultArtifact(gav + ":" + currentProjectArtifact.getVersion());
            }
            catch (IllegalArgumentException ex2) {
                try {
                    result = gav.startsWith(".") && gav.contains(":") ? new DefaultArtifact(currentProjectArtifact.getGroupId() + gav + ":" + currentProjectArtifact.getVersion()) : new DefaultArtifact(currentProjectArtifact.getGroupId() + ":" + gav + ":" + currentProjectArtifact.getVersion());
                }
                catch (IllegalArgumentException ex3) {
                    throw new IllegalArgumentException("Invalid gav: " + gav);
                }
            }
        }
        return result.setFile(this.getRootPom().getParent().resolve(result.getArtifactId()).resolve("pom.xml").toFile());
    }
}

