/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.hello;

import eu.maveniverse.maven.toolbox.plugin.hello.HelloMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.internal.PomSuppliers;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Collections;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import picocli.CommandLine;

@CommandLine.Command(name="new-project", description={"Creates a new project"})
@Mojo(name="new-project", requiresProject=false, threadSafe=true)
public class NewProject
extends HelloMojoSupport {
    @CommandLine.Parameters(index="0", description={"The project GAV"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--packaging"}, description={"Packaging"})
    @Parameter(property="packaging")
    private String packaging;
    @CommandLine.Option(names={"--parent"}, description={"Parent"})
    @Parameter(property="parent")
    private String parent;

    protected Result<Boolean> doExecute() throws Exception {
        if (!this.force && Files.exists(this.getRootPom(), new LinkOption[0])) {
            throw new IllegalStateException("pom.xml already exists in this directory; use --force to overwrite it");
        }
        Artifact projectArtifact = this.toRootProjectArtifact(this.gav);
        Artifact parentArtifact = this.toParentArtifact(this.parent);
        try (ToolboxCommando.EditSession editSession = this.getToolboxCommando().createEditSession(projectArtifact.getFile().toPath());){
            editSession.edit(p -> Files.writeString(p, (CharSequence)PomSuppliers.empty400((String)projectArtifact.getGroupId(), (String)projectArtifact.getArtifactId(), (String)projectArtifact.getVersion()), new OpenOption[0]));
            this.getToolboxCommando().editPom(editSession, Collections.singletonList(s -> {
                String effectivePackaging = "jar";
                if (this.packaging != null) {
                    effectivePackaging = this.packaging;
                } else if (projectArtifact.getGroupId().endsWith("." + projectArtifact.getArtifactId())) {
                    effectivePackaging = "pom";
                }
                s.setPackaging(effectivePackaging);
                if (parentArtifact != null) {
                    s.setParent(parentArtifact);
                }
            }));
        }
        return Result.success((Object)Boolean.TRUE);
    }
}

