/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.hello;

import eu.maveniverse.maven.toolbox.plugin.hello.HelloProjectMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.internal.PomSuppliers;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import picocli.CommandLine;

@CommandLine.Command(name="new-subproject", description={"Creates a new subproject"})
@Mojo(name="new-subproject", requiresProject=false, threadSafe=true)
public class NewSubProject
extends HelloProjectMojoSupport {
    @CommandLine.Parameters(index="0", description={"The subproject GAV"}, arity="1")
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--packaging"}, description={"Packaging"}, defaultValue="jar")
    @Parameter(property="packaging", defaultValue="jar")
    private String packaging;

    protected Result<Boolean> doExecute() throws Exception {
        Artifact subProjectArtifact = this.toSubProjectArtifact(this.gav);
        if (!this.force && Files.exists(subProjectArtifact.getFile().toPath(), new LinkOption[0])) {
            throw new IllegalStateException("pom.xml already exists in this directory; use --force to overwrite it");
        }
        Files.createDirectories(subProjectArtifact.getFile().toPath().getParent(), new FileAttribute[0]);
        try (ToolboxCommando.EditSession editSession = this.getToolboxCommando().createEditSession(subProjectArtifact.getFile().toPath());){
            editSession.edit(p -> Files.writeString(p, (CharSequence)PomSuppliers.empty400((String)subProjectArtifact.getGroupId(), (String)subProjectArtifact.getArtifactId(), (String)subProjectArtifact.getVersion()), new OpenOption[0]));
            this.getToolboxCommando().editPom(editSession, Collections.singletonList(s -> {
                String effectivePackaging = "jar";
                if (this.packaging != null) {
                    effectivePackaging = this.packaging;
                } else if (subProjectArtifact.getGroupId().endsWith("." + subProjectArtifact.getArtifactId())) {
                    effectivePackaging = "pom";
                }
                s.setPackaging(effectivePackaging);
                s.setParent(this.getCurrentProjectArtifact());
            }));
        }
        editSession = this.getToolboxCommando().createEditSession(this.getRootPom());
        try {
            this.getToolboxCommando().editPom(editSession, Collections.singletonList(s -> s.addSubProject(subProjectArtifact.getArtifactId())));
        }
        finally {
            if (editSession != null) {
                editSession.close();
            }
        }
        return Result.success((Object)Boolean.TRUE);
    }
}

