/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionSelector;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="core-extension-versions", requiresProject=false, threadSafe=true)
public class CoreExtensionVersionsMojo
extends MPMojoSupport {
    private static final Logger log = LoggerFactory.getLogger(CoreExtensionVersionsMojo.class);
    @Parameter(property="artifactVersionMatcherSpec", defaultValue="noSnapshotsAndPreviews()")
    private String artifactVersionMatcherSpec;
    @Parameter(property="artifactVersionSelectorSpec", defaultValue="last()")
    private String artifactVersionSelectorSpec;
    @Parameter(property="scope", defaultValue="project")
    private String scope;
    @Parameter(property="apply")
    private boolean apply;

    protected Result<Boolean> doExecute() throws Exception {
        List extensionsUpdates;
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        ArtifactVersionMatcher artifactVersionMatcher = toolboxCommando.parseArtifactVersionMatcherSpec(this.artifactVersionMatcherSpec);
        ArtifactVersionSelector artifactVersionSelector = toolboxCommando.parseArtifactVersionSelectorSpec(this.artifactVersionSelectorSpec);
        ToolboxCommando.ExtensionsScope extensionsScope = ToolboxCommando.ExtensionsScope.valueOf((String)this.scope.toUpperCase(Locale.ROOT));
        Path extensionsXml = extensionsScope == ToolboxCommando.ExtensionsScope.PROJECT ? (this.mavenSession.getRequest().isProjectPresent() ? this.mavenSession.getTopLevelProject().getBasedir().toPath().resolve(".mvn").resolve("extensions.xml") : Path.of(".mvn", new String[0]).resolve("extensions.xml")) : toolboxCommando.extensionsPath(extensionsScope);
        Result extensionsResult = toolboxCommando.listExtensions(extensionsXml);
        if (!extensionsResult.isSuccess()) {
            log.warn("Failed to list extensions from scope {} (path {}): {}", new Object[]{extensionsScope, extensionsXml, extensionsResult.getMessage()});
            return Result.failure((String)extensionsResult.getMessage());
        }
        Result extensions = toolboxCommando.versions(extensionsScope.name().toLowerCase(Locale.ROOT) + " extensions", () -> ((List)extensionsResult.getData().orElseThrow()).stream(), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
        if (this.apply && !(extensionsUpdates = toolboxCommando.calculateUpdates((Map)extensions.getData().orElseThrow(), (BiFunction)artifactVersionSelector)).isEmpty()) {
            try (ToolboxCommando.EditSession editSession = toolboxCommando.createEditSession(extensionsXml);){
                toolboxCommando.editExtensions(editSession, ToolboxCommando.Op.UPDATE, extensionsUpdates::stream);
            }
        }
        return Result.success((Object)true);
    }
}

