/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import picocli.CommandLine;

@Mojo(name="dump", threadSafe=true)
public class DumpMojo
extends MPMojoSupport {
    @CommandLine.Option(names={"--asProperties"}, defaultValue="false", description={"Output it as Java Properties format"})
    @Parameter(property="asProperties", defaultValue="false", required=true)
    private boolean asProperties;
    @CommandLine.Option(names={"--toFile"}, description={"Output it into given file (only if asProperties=true)"})
    @Parameter(property="toFile")
    private File toFile;

    protected Result<String> doExecute() throws IOException {
        if (this.asProperties) {
            Result result = this.getToolboxCommando().dumpAsMap();
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)result.getData().orElse(Collections.emptyMap()));
            if (this.toFile != null) {
                this.toFile.getParentFile().mkdirs();
                try (OutputStream fos = Files.newOutputStream(this.toFile.toPath(), new OpenOption[0]);){
                    properties.store(fos, "Toolbox dump");
                }
            } else {
                properties.store(System.out, "Toolbox dump");
            }
            return Result.success((Object)"success");
        }
        return this.getToolboxCommando().dump();
    }
}

