/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPPluginMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionSelector;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import picocli.CommandLine;

@Mojo(name="extension-versions", threadSafe=true)
public class ExtensionVersionsMojo
extends MPPluginMojoSupport {
    @Parameter(property="artifactMatcherSpec", defaultValue="any()")
    private String artifactMatcherSpec;
    @Parameter(property="artifactVersionMatcherSpec", defaultValue="noSnapshotsAndPreviews()")
    private String artifactVersionMatcherSpec;
    @CommandLine.Option(names={"--artifactVersionSelectorSpec"}, defaultValue="last()", description={"Artifact version selector spec (default 'last()')"})
    @Parameter(property="artifactVersionSelectorSpec", defaultValue="last()")
    private String artifactVersionSelectorSpec;
    @Parameter(property="apply")
    private boolean apply;

    protected Result<Boolean> doExecute() throws Exception {
        List extensionUpdates;
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        ArtifactMatcher artifactMatcher = toolboxCommando.parseArtifactMatcherSpec(this.artifactMatcherSpec);
        ArtifactVersionMatcher artifactVersionMatcher = toolboxCommando.parseArtifactVersionMatcherSpec(this.artifactVersionMatcherSpec);
        ArtifactVersionSelector artifactVersionSelector = toolboxCommando.parseArtifactVersionSelectorSpec(this.artifactVersionSelectorSpec);
        Result extensions = toolboxCommando.versions("extensions", () -> this.allProjectExtensionsAsResolutionRoots(toolboxCommando).stream().map(ResolutionRoot::getArtifact).filter((Predicate<Artifact>)artifactMatcher), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
        if (this.apply && !(extensionUpdates = toolboxCommando.calculateUpdates((Map)extensions.getData().orElseThrow(), (BiFunction)artifactVersionSelector)).isEmpty()) {
            try (ToolboxCommando.EditSession editSession = toolboxCommando.createEditSession(this.mavenProject.getFile().toPath());){
                toolboxCommando.editPom(editSession, ToolboxCommando.PomOpSubject.EXTENSIONS, ToolboxCommando.Op.UPDATE, extensionUpdates::stream);
            }
        }
        return Result.success((Object)true);
    }
}

