/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

@Mojo(name="flatten-bom", threadSafe=true)
public class FlattenBomMojo
extends MPMojoSupport {
    @Parameter(property="gav", defaultValue="${project.groupId}:${project.artifactId}:${project.version}")
    private String gav;
    @Parameter(property="bom", required=true)
    private String bom;
    @Parameter(property="outputFile", defaultValue="${project.build.directory}/flatten-bom.xml", required=true)
    private File outputFile;
    @Parameter(property="attach", defaultValue="false", required=true)
    private boolean attach;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Result<Model> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        DefaultArtifact output = new DefaultArtifact(this.gav);
        DefaultArtifact input = new DefaultArtifact(this.bom);
        Result result = this.isReactorProject((Artifact)input) ? toolboxCommando.flattenBOM((Artifact)output, this.getReactorLocator(input.getGroupId() + ":" + input.getArtifactId() + ":" + input.getVersion())) : toolboxCommando.flattenBOM((Artifact)output, toolboxCommando.loadGav(this.bom));
        if (!result.isSuccess()) return result;
        Model model = (Model)result.getData().orElseThrow();
        try (OutputStream out = Files.newOutputStream(this.outputFile.toPath(), new OpenOption[0]);){
            new MavenXpp3Writer().write(out, model);
        }
        if (this.attach) {
            if (!output.getClassifier().trim().isEmpty()) {
                this.getLog().debug((CharSequence)("Attaching BOM w/ classifier: " + output.getClassifier()));
                org.apache.maven.artifact.DefaultArtifact artifact = new org.apache.maven.artifact.DefaultArtifact(output.getGroupId(), output.getArtifactId(), output.getVersion(), null, "pom", output.getClassifier(), this.artifactHandlerManager.getArtifactHandler("pom"));
                artifact.setFile(this.outputFile);
                this.mavenProject.addAttachedArtifact((org.apache.maven.artifact.Artifact)artifact);
                return result;
            } else {
                if (!Objects.equals("pom", this.mavenProject.getPackaging()) || !this.mavenProject.getModules().isEmpty()) throw new MojoExecutionException("Cannot replace project POM: invalid project (packaging=pom w/o modules)");
                this.getLog().debug((CharSequence)"Replacing module POM w/ generated BOM");
                this.mavenProject.setFile(this.outputFile);
            }
            return result;
        } else {
            Result modelString = toolboxCommando.modelToString(model, false);
            if (!modelString.isSuccess()) return result;
            this.getOutput().tell((String)modelString.getData().orElseThrow(), new Object[0]);
        }
        return result;
    }
}

