/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPPluginMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionSelector;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@Mojo(name="parent-versions", threadSafe=true)
public class ParentVersionsMojo
extends MPPluginMojoSupport {
    private static final Logger log = LoggerFactory.getLogger(ParentVersionsMojo.class);
    @Parameter(property="artifactVersionMatcherSpec", defaultValue="noSnapshotsAndPreviews()")
    private String artifactVersionMatcherSpec;
    @CommandLine.Option(names={"--artifactVersionSelectorSpec"}, defaultValue="last()", description={"Artifact version selector spec (default 'last()')"})
    @Parameter(property="artifactVersionSelectorSpec", defaultValue="last()")
    private String artifactVersionSelectorSpec;
    @Parameter(property="apply")
    private boolean apply;

    protected Result<Boolean> doExecute() throws Exception {
        List parentsUpdates;
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        ArtifactVersionMatcher artifactVersionMatcher = toolboxCommando.parseArtifactVersionMatcherSpec(this.artifactVersionMatcherSpec);
        ArtifactVersionSelector artifactVersionSelector = toolboxCommando.parseArtifactVersionSelectorSpec(this.artifactVersionSelectorSpec);
        if (!this.mavenSession.getRequest().isProjectPresent() || this.mavenProject.getModel().getParent() == null) {
            log.info("No parent found");
            return Result.success((Object)Boolean.TRUE);
        }
        DefaultArtifact parentArtifact = new DefaultArtifact(this.mavenProject.getModel().getParent().getGroupId(), this.mavenProject.getModel().getParent().getArtifactId(), "pom", this.mavenProject.getModel().getParent().getVersion());
        Result parents = toolboxCommando.versions("parent", () -> ParentVersionsMojo.lambda$doExecute$0((Artifact)parentArtifact), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
        if (this.apply && !(parentsUpdates = toolboxCommando.calculateUpdates((Map)parents.getData().orElseThrow(), (BiFunction)artifactVersionSelector)).isEmpty()) {
            try (ToolboxCommando.EditSession editSession = toolboxCommando.createEditSession(this.mavenProject.getFile().toPath());){
                if (!parentsUpdates.isEmpty()) {
                    toolboxCommando.editPom(editSession, Collections.singletonList(s -> s.updateParent(false, (Artifact)parentsUpdates.get(0))));
                }
            }
        }
        return Result.success((Object)true);
    }

    private static /* synthetic */ Stream lambda$doExecute$0(Artifact parentArtifact) throws IOException {
        return Stream.of(parentArtifact);
    }
}

