/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPPluginMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="plugin-list-repositories", threadSafe=true)
public final class PluginListRepositoriesMojo
extends MPPluginMojoSupport {
    @Parameter(property="scope", defaultValue="runtime", required=true)
    private String scope;

    protected Result<List<RemoteRepository>> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        ResolutionRoot root = this.pluginAsResolutionRoot(toolboxCommando, false);
        if (root != null) {
            return toolboxCommando.listRepositories(ResolutionScope.parse((String)this.scope), "plugin", root);
        }
        HashSet repositories = new HashSet();
        for (ResolutionRoot rr : this.allProjectPluginsAsResolutionRoots(toolboxCommando)) {
            Result r = toolboxCommando.listRepositories(ResolutionScope.parse((String)this.scope), "plugin", rr);
            r.getData().ifPresent(repositories::addAll);
        }
        return Result.success(new ArrayList(repositories));
    }
}

