/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPPluginMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionSelector;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import picocli.CommandLine;

@Mojo(name="plugin-versions", threadSafe=true)
public class PluginVersionsMojo
extends MPPluginMojoSupport {
    @Parameter(property="artifactMatcherSpec", defaultValue="any()")
    private String artifactMatcherSpec;
    @Parameter(property="artifactVersionMatcherSpec", defaultValue="noSnapshotsAndPreviews()")
    private String artifactVersionMatcherSpec;
    @CommandLine.Option(names={"--artifactVersionSelectorSpec"}, defaultValue="last()", description={"Artifact version selector spec (default 'last()')"})
    @Parameter(property="artifactVersionSelectorSpec", defaultValue="last()")
    private String artifactVersionSelectorSpec;
    @Parameter(property="apply")
    private boolean apply;

    protected Result<Boolean> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        ArtifactMatcher artifactMatcher = toolboxCommando.parseArtifactMatcherSpec(this.artifactMatcherSpec);
        ArtifactVersionMatcher artifactVersionMatcher = toolboxCommando.parseArtifactVersionMatcherSpec(this.artifactVersionMatcherSpec);
        ArtifactVersionSelector artifactVersionSelector = toolboxCommando.parseArtifactVersionSelectorSpec(this.artifactVersionSelectorSpec);
        Result managedPlugins = toolboxCommando.versions("managed plugins", () -> this.allProjectManagedPluginsAsResolutionRoots(toolboxCommando).stream().map(ResolutionRoot::getArtifact).filter((Predicate<Artifact>)artifactMatcher), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
        Result plugins = toolboxCommando.versions("plugins", () -> this.allProjectPluginsAsResolutionRoots(toolboxCommando).stream().map(ResolutionRoot::getArtifact).filter((Predicate<Artifact>)artifactMatcher), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
        if (this.apply) {
            List managedPluginsUpdates = toolboxCommando.calculateUpdates((Map)managedPlugins.getData().orElseThrow(), (BiFunction)artifactVersionSelector);
            List pluginsUpdates = toolboxCommando.calculateUpdates((Map)plugins.getData().orElseThrow(), (BiFunction)artifactVersionSelector);
            if (!managedPluginsUpdates.isEmpty() || !pluginsUpdates.isEmpty()) {
                try (ToolboxCommando.EditSession editSession = toolboxCommando.createEditSession(this.mavenProject.getFile().toPath());){
                    if (!managedPluginsUpdates.isEmpty()) {
                        toolboxCommando.editPom(editSession, ToolboxCommando.PomOpSubject.MANAGED_PLUGINS, ToolboxCommando.Op.UPDATE, managedPluginsUpdates::stream);
                    }
                    if (!pluginsUpdates.isEmpty()) {
                        toolboxCommando.editPom(editSession, ToolboxCommando.PomOpSubject.PLUGINS, ToolboxCommando.Op.UPDATE, pluginsUpdates::stream);
                    }
                }
            }
        }
        return Result.success((Object)true);
    }
}

