/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPMojoSupport;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.internal.domtrip.SmartPomEditor;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="set-version", aggregator=true, threadSafe=true)
public class SetVersionMojo
extends MPMojoSupport {
    @Parameter(property="version", required=true)
    private String version;
    @Parameter(property="properties")
    private String properties;

    protected Result<Boolean> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        ArrayList<Consumer<SmartPomEditor>> transformers = new ArrayList<Consumer<SmartPomEditor>>();
        transformers.add(s -> s.setVersion(this.version));
        if (this.properties != null) {
            for (String property : this.properties.split(",")) {
                if (property.trim().isEmpty()) continue;
                transformers.add(s -> s.updateProperty(false, property, this.version));
            }
        }
        Result result = Result.success((Object)true);
        for (MavenProject project : this.mavenSession.getProjects()) {
            try (ToolboxCommando.EditSession editSession = toolboxCommando.createEditSession(project.getFile().toPath());){
                result = toolboxCommando.editPom(editSession, transformers);
            }
            if (result.isSuccess()) continue;
            throw new MojoExecutionException("Failed to update version of " + project.getArtifactId());
        }
        return result;
    }
}

