/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.mp;

import eu.maveniverse.maven.toolbox.plugin.MPPluginMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionSelector;
import eu.maveniverse.maven.toolbox.shared.DependencyMatcher;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

@Mojo(name="versions", threadSafe=true)
public class VersionsMojo
extends MPPluginMojoSupport {
    @Parameter(property="artifactVersionMatcherSpec", defaultValue="noSnapshotsAndPreviews()")
    private String artifactVersionMatcherSpec;
    @Parameter(property="artifactVersionSelectorSpec", defaultValue="last()")
    private String artifactVersionSelectorSpec;
    @Parameter(property="effective", defaultValue="false")
    private boolean effective;
    @Parameter(property="apply")
    private boolean apply;

    protected Result<Boolean> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        ArtifactVersionMatcher artifactVersionMatcher = toolboxCommando.parseArtifactVersionMatcherSpec(this.artifactVersionMatcherSpec);
        ArtifactVersionSelector artifactVersionSelector = toolboxCommando.parseArtifactVersionSelectorSpec(this.artifactVersionSelectorSpec);
        ToolboxCommando.ExtensionsScope extensionsScope = ToolboxCommando.ExtensionsScope.PROJECT;
        Path extensionsXml = this.mavenSession.getRequest().isProjectPresent() ? this.mavenSession.getTopLevelProject().getBasedir().toPath().resolve(".mvn").resolve("extensions.xml") : Path.of(".mvn", new String[0]).resolve("extensions.xml");
        Result coreExtensionsDiscovered = toolboxCommando.listExtensions(extensionsXml);
        Result coreExtensions = coreExtensionsDiscovered.isSuccess() ? toolboxCommando.versions(extensionsScope.name().toLowerCase(Locale.ROOT) + " extensions", () -> ((List)coreExtensionsDiscovered.getData().orElseThrow()).stream(), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector) : Result.success(Map.of());
        Result extensions = toolboxCommando.versions("extensions", () -> this.allProjectExtensionsAsResolutionRoots(toolboxCommando).stream().map(ResolutionRoot::getArtifact), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
        AtomicReference<Object> parentArtifact = new AtomicReference<Object>(null);
        if (this.mavenSession.getRequest().isProjectPresent() && this.mavenProject.getModel().getParent() != null) {
            parentArtifact.set(new DefaultArtifact(this.mavenProject.getModel().getParent().getGroupId(), this.mavenProject.getModel().getParent().getArtifactId(), "pom", this.mavenProject.getModel().getParent().getVersion()));
        }
        Result parents = null;
        if (parentArtifact.get() != null) {
            parents = toolboxCommando.versions("parent", () -> Stream.of((Artifact)parentArtifact.get()), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
        }
        Result managedPlugins = toolboxCommando.versions("managed plugins", () -> this.allProjectManagedPluginsAsResolutionRoots(toolboxCommando).stream().map(ResolutionRoot::getArtifact).filter((Predicate<Artifact>)ArtifactMatcher.any()), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
        Result plugins = toolboxCommando.versions("plugins", () -> this.allProjectPluginsAsResolutionRoots(toolboxCommando).stream().map(ResolutionRoot::getArtifact).filter((Predicate<Artifact>)ArtifactMatcher.any()), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
        Result managedDependencies = toolboxCommando.versions("managed dependencies", () -> this.projectManagedDependenciesAsResolutionRoots(this.effective, DependencyMatcher.any()).stream().map(ResolutionRoot::getArtifact), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
        Result dependencies = toolboxCommando.versions("dependencies", () -> this.projectDependenciesAsResolutionRoots(DependencyMatcher.any()).stream().map(ResolutionRoot::getArtifact), (Predicate)artifactVersionMatcher, (BiFunction)artifactVersionSelector);
        if (this.apply) {
            List coreExtensionsUpdates = toolboxCommando.calculateUpdates((Map)coreExtensions.getData().orElseThrow(), (BiFunction)artifactVersionSelector);
            if (!coreExtensionsUpdates.isEmpty()) {
                try (ToolboxCommando.EditSession editSession = toolboxCommando.createEditSession(extensionsXml);){
                    toolboxCommando.editExtensions(editSession, ToolboxCommando.Op.UPDATE, coreExtensionsUpdates::stream);
                }
            }
            AtomicReference<Object> parentsUpdates = new AtomicReference<Object>(null);
            if (parents != null) {
                parentsUpdates.set(toolboxCommando.calculateUpdates((Map)parents.getData().orElseThrow(), (BiFunction)artifactVersionSelector));
            }
            List extensionUpdates = toolboxCommando.calculateUpdates((Map)extensions.getData().orElseThrow(), (BiFunction)artifactVersionSelector);
            List managedPluginsUpdates = toolboxCommando.calculateUpdates((Map)managedPlugins.getData().orElseThrow(), (BiFunction)artifactVersionSelector);
            List pluginsUpdates = toolboxCommando.calculateUpdates((Map)plugins.getData().orElseThrow(), (BiFunction)artifactVersionSelector);
            List managedDependenciesUpdates = toolboxCommando.calculateUpdates((Map)managedDependencies.getData().orElseThrow(), (BiFunction)artifactVersionSelector);
            List dependenciesUpdates = toolboxCommando.calculateUpdates((Map)dependencies.getData().orElseThrow(), (BiFunction)artifactVersionSelector);
            if (!((parentsUpdates.get() == null || ((List)parentsUpdates.get()).isEmpty() || extensionUpdates.isEmpty()) && managedPluginsUpdates.isEmpty() && pluginsUpdates.isEmpty() && managedDependenciesUpdates.isEmpty() && dependenciesUpdates.isEmpty())) {
                try (ToolboxCommando.EditSession editSession = toolboxCommando.createEditSession(this.mavenProject.getFile().toPath());){
                    if (parentsUpdates.get() != null && !((List)parentsUpdates.get()).isEmpty()) {
                        toolboxCommando.editPom(editSession, Collections.singletonList(s -> s.updateParent(false, (Artifact)((List)parentsUpdates.get()).get(0))));
                    }
                    if (!extensionUpdates.isEmpty()) {
                        toolboxCommando.editPom(editSession, ToolboxCommando.PomOpSubject.EXTENSIONS, ToolboxCommando.Op.UPDATE, extensionUpdates::stream);
                    }
                    if (!managedPluginsUpdates.isEmpty()) {
                        toolboxCommando.editPom(editSession, ToolboxCommando.PomOpSubject.MANAGED_PLUGINS, ToolboxCommando.Op.UPDATE, managedPluginsUpdates::stream);
                    }
                    if (!pluginsUpdates.isEmpty()) {
                        toolboxCommando.editPom(editSession, ToolboxCommando.PomOpSubject.PLUGINS, ToolboxCommando.Op.UPDATE, pluginsUpdates::stream);
                    }
                    if (!managedDependenciesUpdates.isEmpty()) {
                        toolboxCommando.editPom(editSession, ToolboxCommando.PomOpSubject.MANAGED_DEPENDENCIES, ToolboxCommando.Op.UPDATE, managedDependenciesUpdates::stream);
                    }
                    if (!dependenciesUpdates.isEmpty()) {
                        toolboxCommando.editPom(editSession, ToolboxCommando.PomOpSubject.DEPENDENCIES, ToolboxCommando.Op.UPDATE, dependenciesUpdates::stream);
                    }
                }
            }
        }
        return Result.success((Object)true);
    }
}

