/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import eu.maveniverse.maven.toolbox.shared.internal.SpecParser;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.aether.artifact.Artifact;

public interface ArtifactDifferentiator
extends Function<Artifact, String> {
    public static ArtifactDifferentiator majorVersion() {
        return new ArtifactDifferentiator(){

            @Override
            public String apply(Artifact artifact) {
                String ver = artifact.getVersion();
                int firstDot = ver.indexOf(46);
                if (firstDot > 0) {
                    return ver.substring(0, firstDot);
                }
                return artifact.getVersion();
            }
        };
    }

    public static ArtifactDifferentiator minorVersion() {
        return new ArtifactDifferentiator(){

            @Override
            public String apply(Artifact artifact) {
                int secondDot;
                String ver = artifact.getVersion();
                int firstDot = ver.indexOf(46);
                if (firstDot > 0 && (secondDot = ver.indexOf(46, firstDot + 1)) > firstDot) {
                    return ver.substring(0, secondDot);
                }
                return artifact.getVersion();
            }
        };
    }

    public static ArtifactDifferentiator baseVersion() {
        return new ArtifactDifferentiator(){

            @Override
            public String apply(Artifact artifact) {
                return artifact.getBaseVersion();
            }
        };
    }

    public static ArtifactDifferentiator version() {
        return new ArtifactDifferentiator(){

            @Override
            public String apply(Artifact artifact) {
                return artifact.getVersion();
            }
        };
    }

    public static ArtifactDifferentiator build(Map<String, ?> properties, String spec) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(spec, "spec");
        ArtifactKeyFactoryBuilder builder = new ArtifactKeyFactoryBuilder(properties);
        try {
            SpecParser.parse(spec).accept(builder);
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid artifact differentiator spec: " + spec, e);
        }
    }

    public static class ArtifactKeyFactoryBuilder
    extends SpecParser.Builder {
        public ArtifactKeyFactoryBuilder(Map<String, ?> properties) {
            super(properties);
        }

        @Override
        protected void processOp(SpecParser.Node node) {
            switch (node.getValue()) {
                case "majorVersion": {
                    this.params.add(ArtifactDifferentiator.majorVersion());
                    break;
                }
                case "minorVersion": {
                    this.params.add(ArtifactDifferentiator.minorVersion());
                    break;
                }
                case "baseVersion": {
                    this.params.add(ArtifactDifferentiator.baseVersion());
                    break;
                }
                case "version": {
                    this.params.add(ArtifactDifferentiator.version());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown op " + node.getValue());
                }
            }
        }

        public ArtifactDifferentiator build() {
            return this.build(ArtifactDifferentiator.class);
        }
    }
}

