/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import eu.maveniverse.maven.toolbox.shared.internal.SpecParser;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

public interface ArtifactKeyFactory
extends Function<Artifact, String> {
    public static ArtifactKeyFactory id() {
        return new ArtifactKeyFactory(){

            @Override
            public String apply(Artifact artifact) {
                return ArtifactIdUtils.toId((Artifact)artifact);
            }
        };
    }

    public static ArtifactKeyFactory baseId() {
        return new ArtifactKeyFactory(){

            @Override
            public String apply(Artifact artifact) {
                return ArtifactIdUtils.toBaseId((Artifact)artifact);
            }
        };
    }

    public static ArtifactKeyFactory versionlessId() {
        return new ArtifactKeyFactory(){

            @Override
            public String apply(Artifact artifact) {
                return ArtifactIdUtils.toVersionlessId((Artifact)artifact);
            }
        };
    }

    public static ArtifactKeyFactory ga() {
        return new ArtifactKeyFactory(){

            @Override
            public String apply(Artifact artifact) {
                return artifact.getGroupId() + ":" + artifact.getArtifactId();
            }
        };
    }

    public static ArtifactKeyFactory build(Map<String, ?> properties, String spec) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(spec, "spec");
        ArtifactKeyFactoryBuilder builder = new ArtifactKeyFactoryBuilder(properties);
        try {
            SpecParser.parse(spec).accept(builder);
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid artifact key factory spec:" + spec, e);
        }
    }

    public static class ArtifactKeyFactoryBuilder
    extends SpecParser.Builder {
        public ArtifactKeyFactoryBuilder(Map<String, ?> properties) {
            super(properties);
        }

        @Override
        protected void processOp(SpecParser.Node node) {
            switch (node.getValue()) {
                case "id": {
                    this.params.add(ArtifactKeyFactory.id());
                    break;
                }
                case "baseId": {
                    this.params.add(ArtifactKeyFactory.baseId());
                    break;
                }
                case "versionlessId": {
                    this.params.add(ArtifactKeyFactory.versionlessId());
                    break;
                }
                case "ga": {
                    this.params.add(ArtifactKeyFactory.ga());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown op " + node.getValue());
                }
            }
        }

        public ArtifactKeyFactory build() {
            return this.build(ArtifactKeyFactory.class);
        }
    }
}

