/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import eu.maveniverse.maven.toolbox.shared.internal.SpecParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.aether.artifact.Artifact;

public interface ArtifactNameMapper
extends Function<Artifact, String> {
    public static ArtifactNameMapper compose(ArtifactNameMapper ... mappers) {
        return ArtifactNameMapper.compose(Arrays.asList(mappers));
    }

    public static ArtifactNameMapper compose(final Collection<ArtifactNameMapper> mappers) {
        return new ArtifactNameMapper(){

            @Override
            public String apply(Artifact artifact) {
                Object result = "";
                for (ArtifactNameMapper mapper : mappers) {
                    result = (String)result + (String)mapper.apply(artifact);
                }
                return result;
            }
        };
    }

    public static ArtifactNameMapper empty() {
        return artifact -> "";
    }

    public static ArtifactNameMapper fixed(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        if (prefix.trim().isEmpty()) {
            throw new IllegalArgumentException("invalid prefix");
        }
        return artifact -> prefix;
    }

    public static ArtifactNameMapper optionalPrefix(String prefix, ArtifactNameMapper artifactNameMapper) {
        Objects.requireNonNull(prefix, "prefix");
        Objects.requireNonNull(artifactNameMapper, "artifactNameMapper");
        if (prefix.trim().isEmpty()) {
            throw new IllegalArgumentException("invalid prefix");
        }
        return artifact -> {
            String val = (String)artifactNameMapper.apply(artifact);
            if (val != null && !val.trim().isEmpty()) {
                return prefix + val;
            }
            return "";
        };
    }

    public static ArtifactNameMapper optionalSuffix(String suffix, ArtifactNameMapper artifactNameMapper) {
        Objects.requireNonNull(suffix, "suffix");
        Objects.requireNonNull(artifactNameMapper, "artifactNameMapper");
        if (suffix.trim().isEmpty()) {
            throw new IllegalArgumentException("invalid suffix");
        }
        return artifact -> {
            String val = (String)artifactNameMapper.apply(artifact);
            if (val != null && !val.trim().isEmpty()) {
                return val + suffix;
            }
            return "";
        };
    }

    public static ArtifactNameMapper repositoryDefault() {
        return ArtifactNameMapper.repository(File.separator);
    }

    public static ArtifactNameMapper repository(String fs) {
        return artifact -> {
            StringBuilder path = new StringBuilder(128);
            path.append(artifact.getGroupId().replace(".", fs)).append(fs);
            path.append(artifact.getArtifactId()).append(fs);
            path.append(artifact.getBaseVersion()).append(fs);
            path.append(artifact.getArtifactId()).append("-").append(artifact.getVersion());
            if (!artifact.getClassifier().isEmpty()) {
                path.append("-").append(artifact.getClassifier());
            }
            path.append(".").append(artifact.getExtension());
            return path.toString();
        };
    }

    public static ArtifactNameMapper GAKey() {
        return artifact -> artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    public static ArtifactNameMapper GAVKey() {
        return artifact -> artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
    }

    public static ArtifactNameMapper GAbVKey() {
        return artifact -> artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
    }

    public static ArtifactNameMapper GACEVKey() {
        return Artifact::toString;
    }

    public static ArtifactNameMapper G() {
        return Artifact::getGroupId;
    }

    public static ArtifactNameMapper A() {
        return Artifact::getArtifactId;
    }

    public static ArtifactNameMapper V() {
        return Artifact::getVersion;
    }

    public static ArtifactNameMapper bV() {
        return Artifact::getBaseVersion;
    }

    public static ArtifactNameMapper C() {
        return Artifact::getClassifier;
    }

    public static ArtifactNameMapper E() {
        return Artifact::getExtension;
    }

    public static ArtifactNameMapper P(String key, String def) {
        return a -> a.getProperty(key, def);
    }

    public static ArtifactNameMapper GACVE() {
        return artifact -> {
            String result = artifact.getGroupId() + ".";
            result = result + artifact.getArtifactId();
            if (!artifact.getClassifier().isEmpty()) {
                result = result + "-" + artifact.getClassifier();
            }
            result = result + "-" + artifact.getVersion();
            result = result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper GACbVE() {
        return artifact -> {
            String result = artifact.getGroupId() + ".";
            result = result + artifact.getArtifactId();
            if (!artifact.getClassifier().isEmpty()) {
                result = result + "-" + artifact.getClassifier();
            }
            result = result + "-" + artifact.getBaseVersion();
            result = result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper GACE() {
        return artifact -> {
            String result = artifact.getGroupId() + ".";
            result = result + artifact.getArtifactId();
            if (!artifact.getClassifier().isEmpty()) {
                result = result + "-" + artifact.getClassifier();
            }
            result = result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper GAVE() {
        return artifact -> {
            String result = artifact.getGroupId() + ".";
            result = result + artifact.getArtifactId();
            result = result + "-" + artifact.getVersion();
            result = result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper GAbVE() {
        return artifact -> {
            String result = artifact.getGroupId() + ".";
            result = result + artifact.getArtifactId();
            result = result + "-" + artifact.getBaseVersion();
            result = result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper GAE() {
        return artifact -> {
            String result = artifact.getGroupId() + ".";
            result = result + artifact.getArtifactId();
            result = result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper ACVE() {
        return artifact -> {
            Object result = artifact.getArtifactId();
            if (!artifact.getClassifier().isEmpty()) {
                result = (String)result + "-" + artifact.getClassifier();
            }
            result = (String)result + "-" + artifact.getVersion();
            result = (String)result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper AVCE() {
        return artifact -> {
            Object result = artifact.getArtifactId();
            result = (String)result + "-" + artifact.getVersion();
            if (!artifact.getClassifier().isEmpty()) {
                result = (String)result + "-" + artifact.getClassifier();
            }
            result = (String)result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper ACbVE() {
        return artifact -> {
            Object result = artifact.getArtifactId();
            if (!artifact.getClassifier().isEmpty()) {
                result = (String)result + "-" + artifact.getClassifier();
            }
            result = (String)result + "-" + artifact.getBaseVersion();
            result = (String)result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper AbVCE() {
        return artifact -> {
            Object result = artifact.getArtifactId();
            result = (String)result + "-" + artifact.getBaseVersion();
            if (!artifact.getClassifier().isEmpty()) {
                result = (String)result + "-" + artifact.getClassifier();
            }
            result = (String)result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper ACE() {
        return artifact -> {
            Object result = artifact.getArtifactId();
            if (!artifact.getClassifier().isEmpty()) {
                result = (String)result + "-" + artifact.getClassifier();
            }
            result = (String)result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper AVE() {
        return artifact -> {
            Object result = artifact.getArtifactId();
            result = (String)result + "-" + artifact.getVersion();
            result = (String)result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper AbVE() {
        return artifact -> {
            Object result = artifact.getArtifactId();
            result = (String)result + "-" + artifact.getBaseVersion();
            result = (String)result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper AE() {
        return artifact -> {
            Object result = artifact.getArtifactId();
            result = (String)result + "." + artifact.getExtension();
            return result;
        };
    }

    public static ArtifactNameMapper build(Map<String, ?> properties, String spec) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(spec, "spec");
        ArtifactNameMapperBuilder builder = new ArtifactNameMapperBuilder(properties);
        try {
            SpecParser.parse(spec).accept(builder);
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid artifact name mapper spec: " + spec, e);
        }
    }

    public static class ArtifactNameMapperBuilder
    extends SpecParser.Builder {
        public ArtifactNameMapperBuilder(Map<String, ?> properties) {
            super(properties);
        }

        @Override
        protected void processOp(SpecParser.Node node) {
            switch (node.getValue()) {
                case "GAKey": {
                    this.params.add(ArtifactNameMapper.GAKey());
                    break;
                }
                case "GAVKey": {
                    this.params.add(ArtifactNameMapper.GAVKey());
                    break;
                }
                case "GAbVKey": {
                    this.params.add(ArtifactNameMapper.GAbVKey());
                    break;
                }
                case "GACEVKey": {
                    this.params.add(ArtifactNameMapper.GACEVKey());
                    break;
                }
                case "G": {
                    this.params.add(ArtifactNameMapper.G());
                    break;
                }
                case "A": {
                    this.params.add(ArtifactNameMapper.A());
                    break;
                }
                case "V": {
                    this.params.add(ArtifactNameMapper.V());
                    break;
                }
                case "bV": {
                    this.params.add(ArtifactNameMapper.bV());
                    break;
                }
                case "C": {
                    this.params.add(ArtifactNameMapper.C());
                    break;
                }
                case "E": {
                    this.params.add(ArtifactNameMapper.E());
                    break;
                }
                case "P": {
                    String p1 = this.stringParam(node.getValue());
                    String p0 = this.stringParam(node.getValue());
                    this.params.add(ArtifactNameMapper.P(p0, p1));
                    break;
                }
                case "GACVE": {
                    this.params.add(ArtifactNameMapper.GACVE());
                    break;
                }
                case "GACbVE": {
                    this.params.add(ArtifactNameMapper.GACbVE());
                    break;
                }
                case "GACE": {
                    this.params.add(ArtifactNameMapper.GACE());
                    break;
                }
                case "GAVE": {
                    this.params.add(ArtifactNameMapper.GAVE());
                    break;
                }
                case "GAbVE": {
                    this.params.add(ArtifactNameMapper.GAbVE());
                    break;
                }
                case "GAE": {
                    this.params.add(ArtifactNameMapper.GAE());
                    break;
                }
                case "ACVE": {
                    this.params.add(ArtifactNameMapper.ACVE());
                    break;
                }
                case "AVCE": {
                    this.params.add(ArtifactNameMapper.AVCE());
                    break;
                }
                case "ACbVE": {
                    this.params.add(ArtifactNameMapper.ACbVE());
                    break;
                }
                case "AbVCE": {
                    this.params.add(ArtifactNameMapper.AbVCE());
                    break;
                }
                case "ACE": {
                    this.params.add(ArtifactNameMapper.ACE());
                    break;
                }
                case "AVE": {
                    this.params.add(ArtifactNameMapper.AVE());
                    break;
                }
                case "AbVE": {
                    this.params.add(ArtifactNameMapper.AbVE());
                    break;
                }
                case "AE": {
                    this.params.add(ArtifactNameMapper.AE());
                    break;
                }
                case "empty": {
                    this.params.add(ArtifactNameMapper.empty());
                    break;
                }
                case "fixed": {
                    this.params.add(ArtifactNameMapper.fixed(this.stringParam(node.getValue())));
                    break;
                }
                case "optionalPrefix": {
                    ArtifactNameMapper p1 = this.typedParam(ArtifactNameMapper.class, node.getValue());
                    String p0 = this.stringParam(node.getValue());
                    this.params.add(ArtifactNameMapper.optionalPrefix(p0, p1));
                    break;
                }
                case "optionalSuffix": {
                    ArtifactNameMapper p1 = this.typedParam(ArtifactNameMapper.class, node.getValue());
                    String p0 = this.stringParam(node.getValue());
                    this.params.add(ArtifactNameMapper.optionalSuffix(p0, p1));
                    break;
                }
                case "repositoryDefault": {
                    this.params.add(ArtifactNameMapper.repositoryDefault());
                    break;
                }
                case "repository": {
                    this.params.add(ArtifactNameMapper.repository(this.stringParam(node.getValue())));
                    break;
                }
                case "compose": {
                    ArrayList<ArtifactNameMapper> mappers = new ArrayList<ArtifactNameMapper>(this.typedParams(ArtifactNameMapper.class, node.getValue()));
                    Collections.reverse(mappers);
                    this.params.add(ArtifactNameMapper.compose(mappers));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown op " + node.getValue());
                }
            }
        }

        public ArtifactNameMapper build() {
            return this.build(ArtifactNameMapper.class);
        }
    }
}

