/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import eu.maveniverse.maven.toolbox.shared.internal.SpecParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;

public interface ArtifactVersionMatcher
extends Predicate<Version> {
    public static ArtifactVersionMatcher any() {
        return v -> true;
    }

    public static ArtifactVersionMatcher not(final ArtifactVersionMatcher matcher) {
        return new ArtifactVersionMatcher(){

            @Override
            public boolean test(Version version) {
                return !matcher.test(version);
            }
        };
    }

    public static ArtifactVersionMatcher and(ArtifactVersionMatcher ... matchers) {
        return ArtifactVersionMatcher.and(Arrays.asList(matchers));
    }

    public static ArtifactVersionMatcher and(final Collection<ArtifactVersionMatcher> matchers) {
        return new ArtifactVersionMatcher(){

            @Override
            public boolean test(Version version) {
                for (ArtifactVersionMatcher matcher : matchers) {
                    if (matcher.test(version)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static ArtifactVersionMatcher or(ArtifactVersionMatcher ... matchers) {
        return ArtifactVersionMatcher.or(Arrays.asList(matchers));
    }

    public static ArtifactVersionMatcher or(final Collection<ArtifactVersionMatcher> matchers) {
        return new ArtifactVersionMatcher(){

            @Override
            public boolean test(Version version) {
                for (ArtifactVersionMatcher matcher : matchers) {
                    if (!matcher.test(version)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static ArtifactVersionMatcher eq(Version version) {
        return arg_0 -> ((Version)version).equals(arg_0);
    }

    public static ArtifactVersionMatcher gt(Version version) {
        return v -> version.compareTo(v) < 0;
    }

    public static ArtifactVersionMatcher gte(Version version) {
        return v -> version.compareTo(v) <= 0;
    }

    public static ArtifactVersionMatcher lt(Version version) {
        return v -> version.compareTo(v) > 0;
    }

    public static ArtifactVersionMatcher lte(Version version) {
        return v -> version.compareTo(v) >= 0;
    }

    public static ArtifactVersionMatcher preview() {
        return ArtifactVersionMatcher::isPreviewVersion;
    }

    public static ArtifactVersionMatcher snapshot() {
        return ArtifactVersionMatcher::isSnapshotVersion;
    }

    public static ArtifactVersionMatcher noPreviews() {
        return ArtifactVersionMatcher.not(ArtifactVersionMatcher.preview());
    }

    public static ArtifactVersionMatcher noSnapshots() {
        return ArtifactVersionMatcher.not(ArtifactVersionMatcher.snapshot());
    }

    public static ArtifactVersionMatcher noSnapshotsAndPreviews() {
        return ArtifactVersionMatcher.and(ArtifactVersionMatcher.noPreviews(), ArtifactVersionMatcher.noSnapshots());
    }

    public static boolean isPreviewVersion(Version version) {
        return ArtifactVersionMatcher.isPreviewVersion(version.toString());
    }

    public static boolean isPreviewVersion(String version) {
        if (version.length() > 1) {
            String ver = version.toLowerCase(Locale.ENGLISH);
            if (ver.contains("alpha") || ver.contains("beta") || ver.contains("milestone") || ver.contains("rc") || ver.contains("cr")) {
                return true;
            }
            for (char ch : new char[]{'a', 'b', 'm'}) {
                int idx = ver.lastIndexOf(ch);
                if (idx <= -1 || ver.length() <= idx + 1 || !Character.isDigit(ver.charAt(idx + 1))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSnapshotVersion(Version version) {
        return ArtifactVersionMatcher.isSnapshotVersion(version.toString());
    }

    public static boolean isSnapshotVersion(String version) {
        try {
            return new DefaultArtifact("g:a:" + version).isSnapshot();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static ArtifactVersionMatcher build(VersionScheme versionScheme, Map<String, ?> properties, String spec) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(spec, "spec");
        ArtifactVersionMatcherBuilder builder = new ArtifactVersionMatcherBuilder(versionScheme, properties);
        try {
            SpecParser.parse(spec).accept(builder);
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid version matcher spec: " + spec, e);
        }
    }

    public static class ArtifactVersionMatcherBuilder
    extends SpecParser.Builder {
        private final VersionScheme versionScheme;

        public ArtifactVersionMatcherBuilder(VersionScheme versionScheme, Map<String, ?> properties) {
            super(properties);
            this.versionScheme = versionScheme;
        }

        @Override
        protected void processOp(SpecParser.Node node) {
            switch (node.getValue()) {
                case "any": {
                    this.params.add(ArtifactVersionMatcher.any());
                    break;
                }
                case "preview": {
                    this.params.add(ArtifactVersionMatcher.preview());
                    break;
                }
                case "snapshot": {
                    this.params.add(ArtifactVersionMatcher.snapshot());
                    break;
                }
                case "not": {
                    this.params.add(ArtifactVersionMatcher.not(this.typedParam(ArtifactVersionMatcher.class, node.getValue())));
                    break;
                }
                case "and": {
                    this.params.add(ArtifactVersionMatcher.and(this.typedParams(ArtifactVersionMatcher.class, node.getValue())));
                    break;
                }
                case "or": {
                    this.params.add(ArtifactVersionMatcher.or(this.typedParams(ArtifactVersionMatcher.class, node.getValue())));
                    break;
                }
                case "eq": {
                    this.params.add(ArtifactVersionMatcher.eq(this.versionParam(node.getValue())));
                    break;
                }
                case "gt": {
                    this.params.add(ArtifactVersionMatcher.gt(this.versionParam(node.getValue())));
                    break;
                }
                case "gte": {
                    this.params.add(ArtifactVersionMatcher.gte(this.versionParam(node.getValue())));
                    break;
                }
                case "lt": {
                    this.params.add(ArtifactVersionMatcher.lt(this.versionParam(node.getValue())));
                    break;
                }
                case "lte": {
                    this.params.add(ArtifactVersionMatcher.lte(this.versionParam(node.getValue())));
                    break;
                }
                case "noPreviews": {
                    this.params.add(ArtifactVersionMatcher.noPreviews());
                    break;
                }
                case "noSnapshots": {
                    this.params.add(ArtifactVersionMatcher.noSnapshots());
                    break;
                }
                case "noSnapshotsAndPreviews": {
                    this.params.add(ArtifactVersionMatcher.noSnapshotsAndPreviews());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown op " + node.getValue());
                }
            }
        }

        protected Version versionParam(String op) {
            try {
                return this.versionScheme.parseVersion(this.stringParam(op));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalArgumentException("invalid version parameter for " + op, e);
            }
        }

        public ArtifactVersionMatcher build() {
            return this.build(ArtifactVersionMatcher.class);
        }
    }
}

