/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import eu.maveniverse.maven.toolbox.shared.internal.SpecParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;

public interface DependencyMapper
extends Function<Dependency, Dependency> {
    public static DependencyMapper compose(DependencyMapper ... mappers) {
        return DependencyMapper.compose(Arrays.asList(mappers));
    }

    public static DependencyMapper compose(final Collection<DependencyMapper> mappers) {
        return new DependencyMapper(){

            @Override
            public Dependency apply(Dependency dependency) {
                for (DependencyMapper mapper : mappers) {
                    dependency = (Dependency)mapper.apply(dependency);
                }
                return dependency;
            }
        };
    }

    public static DependencyMapper identity() {
        return new DependencyMapper(){

            @Override
            public Dependency apply(Dependency dependency) {
                return dependency;
            }
        };
    }

    public static DependencyMapper optional(final boolean optional) {
        return new DependencyMapper(){

            @Override
            public Dependency apply(Dependency dependency) {
                return dependency.setOptional(Boolean.valueOf(optional));
            }
        };
    }

    public static DependencyMapper scope(final String scope) {
        return new DependencyMapper(){

            @Override
            public Dependency apply(Dependency dependency) {
                return dependency.setScope(scope);
            }
        };
    }

    public static DependencyMapper exclusion(final Collection<String> exclusions) {
        Objects.requireNonNull(exclusions, "exclusions");
        return new DependencyMapper(){

            @Override
            public Dependency apply(Dependency dependency) {
                return dependency.setExclusions((Collection)exclusions.stream().map(a -> new DefaultArtifact(a + ":irrelevant")).map(a -> new Exclusion(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension())).collect(Collectors.toList()));
            }
        };
    }

    public static class DependencyMapperBuilder
    extends SpecParser.Builder {
        public DependencyMapperBuilder(Map<String, ?> properties) {
            super(properties);
        }

        @Override
        protected void processOp(SpecParser.Node node) {
            switch (node.getValue()) {
                case "identity": {
                    this.params.add(DependencyMapper.identity());
                    break;
                }
                case "compose": {
                    this.params.add(DependencyMapper.compose(this.typedParams(DependencyMapper.class, node.getValue())));
                    break;
                }
                case "optional": {
                    this.params.add(DependencyMapper.optional(this.booleanParam(node.getValue())));
                    break;
                }
                case "scope": {
                    this.params.add(DependencyMapper.scope(this.stringParam(node.getValue())));
                    break;
                }
                case "exclusion": {
                    this.params.add(DependencyMapper.exclusion(this.stringParams(node.getValue())));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown op " + node.getValue());
                }
            }
        }

        public DependencyMapper build() {
            return this.build(DependencyMapper.class);
        }
    }
}

