/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.internal.SpecParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.aether.graph.Dependency;

public interface DependencyMatcher
extends Predicate<Dependency> {
    public static DependencyMatcher not(final DependencyMatcher matcher) {
        return new DependencyMatcher(){

            @Override
            public boolean test(Dependency dependency) {
                return !matcher.test(dependency);
            }
        };
    }

    public static DependencyMatcher and(DependencyMatcher ... matchers) {
        return DependencyMatcher.and(Arrays.asList(matchers));
    }

    public static DependencyMatcher and(final Collection<DependencyMatcher> matchers) {
        return new DependencyMatcher(){

            @Override
            public boolean test(Dependency dependency) {
                for (DependencyMatcher matcher : matchers) {
                    if (matcher.test(dependency)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static DependencyMatcher or(DependencyMatcher ... matchers) {
        return DependencyMatcher.or(Arrays.asList(matchers));
    }

    public static DependencyMatcher or(final Collection<DependencyMatcher> matchers) {
        return new DependencyMatcher(){

            @Override
            public boolean test(Dependency dependency) {
                for (DependencyMatcher matcher : matchers) {
                    if (!matcher.test(dependency)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static DependencyMatcher any() {
        return dependency -> true;
    }

    public static DependencyMatcher none() {
        return dependency -> false;
    }

    public static DependencyMatcher artifact(final ArtifactMatcher artifactMatcher) {
        return new DependencyMatcher(){

            @Override
            public boolean test(Dependency dependency) {
                return artifactMatcher.test(dependency.getArtifact());
            }
        };
    }

    public static DependencyMatcher scope(Collection<String> included, Collection<String> excluded) {
        final HashSet<String> includedSet = included == null ? null : new HashSet<String>(included);
        final HashSet<String> excludedSet = excluded == null ? null : new HashSet<String>(excluded);
        return new DependencyMatcher(){

            @Override
            public boolean test(Dependency dependency) {
                String scope = dependency.getScope();
                return !(includedSet != null && !includedSet.contains(scope) || excludedSet != null && excludedSet.contains(scope));
            }
        };
    }

    public static DependencyMatcher optional(final boolean optional) {
        return new DependencyMatcher(){

            @Override
            public boolean test(Dependency dependency) {
                return dependency.isOptional() == optional;
            }
        };
    }

    public static DependencyMatcher build(Map<String, ?> properties, String spec) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(spec, "spec");
        DependencyMatcherBuilder builder = new DependencyMatcherBuilder(properties);
        try {
            SpecParser.parse(spec).accept(builder);
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid dependency matcher spec: " + spec, e);
        }
    }

    public static class DependencyMatcherBuilder
    extends SpecParser.Builder {
        public DependencyMatcherBuilder(Map<String, ?> properties) {
            super(properties);
        }

        @Override
        public boolean visitEnter(SpecParser.Node node) {
            return super.visitEnter(node) && !"artifact".equals(node.getValue());
        }

        @Override
        protected void processOp(SpecParser.Node node) {
            switch (node.getValue()) {
                case "any": {
                    this.params.add(DependencyMatcher.any());
                    break;
                }
                case "none": {
                    this.params.add(DependencyMatcher.none());
                    break;
                }
                case "scopeIncluded": {
                    this.params.add(DependencyMatcher.scope(this.stringParams(node.getValue()), null));
                    break;
                }
                case "scopeExcluded": {
                    this.params.add(DependencyMatcher.scope(null, this.stringParams(node.getValue())));
                    break;
                }
                case "optional": {
                    this.params.add(DependencyMatcher.optional(Boolean.parseBoolean(this.stringParam(node.getValue()))));
                    break;
                }
                case "artifact": {
                    if (node.getChildren().size() != 1) {
                        throw new IllegalArgumentException("op artifact accepts only 1 argument");
                    }
                    ArtifactMatcher.ArtifactMatcherBuilder matcher = new ArtifactMatcher.ArtifactMatcherBuilder(this.properties);
                    node.accept(matcher);
                    this.params.add(DependencyMatcher.artifact(matcher.build()));
                    node.getChildren().clear();
                    break;
                }
                case "not": {
                    this.params.add(DependencyMatcher.not(this.typedParam(DependencyMatcher.class, node.getValue())));
                    break;
                }
                case "and": {
                    this.params.add(DependencyMatcher.and(this.typedParams(DependencyMatcher.class, node.getValue())));
                    break;
                }
                case "or": {
                    this.params.add(DependencyMatcher.or(this.typedParams(DependencyMatcher.class, node.getValue())));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown op " + node.getValue());
                }
            }
        }

        public DependencyMatcher build() {
            return this.build(DependencyMatcher.class);
        }
    }
}

