/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

public final class ResolutionRoot {
    private final Artifact artifact;
    private final boolean load;
    private final boolean applyManagedDependencies;
    private final boolean cutDependencies;
    private final boolean prepared;
    private final List<Dependency> dependencies;
    private final List<Dependency> managedDependencies;

    private ResolutionRoot(Artifact artifact, boolean load, boolean applyManagedDependencies, boolean cutDependencies, boolean prepared, List<Dependency> dependencies, List<Dependency> managedDependencies) {
        this.artifact = artifact;
        this.load = load;
        this.applyManagedDependencies = applyManagedDependencies;
        this.cutDependencies = cutDependencies;
        this.prepared = prepared;
        this.dependencies = dependencies.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(dependencies);
        this.managedDependencies = managedDependencies.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(managedDependencies);
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public boolean isLoad() {
        return this.load;
    }

    public boolean isApplyManagedDependencies() {
        return this.applyManagedDependencies;
    }

    public boolean isCutDependencies() {
        return this.cutDependencies;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public ResolutionRoot prepared() {
        List<Dependency> newDependencies = this.dependencies;
        if (this.applyManagedDependencies) {
            newDependencies = new ArrayList<Dependency>(this.dependencies.size());
            for (Dependency dependency : this.dependencies) {
                if (this.cutDependencies || dependency.isOptional()) continue;
                String key = ArtifactIdUtils.toVersionlessId((Artifact)dependency.getArtifact());
                Optional<Dependency> managed = this.managedDependencies.stream().filter(d -> key.equals(ArtifactIdUtils.toVersionlessId((Artifact)d.getArtifact()))).findFirst();
                if (managed.isPresent()) {
                    Dependency managedDependency = managed.orElseThrow();
                    if (!managedDependency.getArtifact().getVersion().trim().isEmpty()) {
                        dependency = dependency.setArtifact(dependency.getArtifact().setVersion(managedDependency.getArtifact().getVersion()));
                    }
                    if (!managedDependency.getScope().trim().isEmpty()) {
                        dependency = dependency.setScope(managedDependency.getScope());
                    }
                    if (managedDependency.getOptional() != null) {
                        dependency = dependency.setOptional(managedDependency.getOptional());
                    }
                    if (!managedDependency.getExclusions().isEmpty()) {
                        dependency = dependency.setExclusions(managedDependency.getExclusions());
                    }
                }
                newDependencies.add(dependency);
            }
        }
        return new ResolutionRoot(this.artifact, this.load, false, false, true, newDependencies, this.managedDependencies);
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<Dependency> getManagedDependencies() {
        return this.managedDependencies;
    }

    public Builder builder() {
        return new Builder(this.artifact, this.load, this.applyManagedDependencies, this.cutDependencies, this.dependencies, this.managedDependencies);
    }

    public static Builder ofLoaded(Artifact artifact) {
        return new Builder(artifact).load();
    }

    public static Builder ofNotLoaded(Artifact artifact) {
        return new Builder(artifact).doNotLoad();
    }

    public static final class Builder {
        private final Artifact artifact;
        private boolean load;
        private boolean applyManagedDependencies;
        private boolean cutDependencies;
        private List<Dependency> dependencies;
        private List<Dependency> managedDependencies;

        private Builder(Artifact artifact) {
            this(artifact, false, false, false, Collections.emptyList(), Collections.emptyList());
        }

        private Builder(Artifact artifact, boolean load, boolean applyManagedDependencies, boolean cutDependencies, List<Dependency> dependencies, List<Dependency> managedDependencies) {
            this.artifact = Objects.requireNonNull(artifact, "artifact");
            this.load = load;
            this.applyManagedDependencies = applyManagedDependencies;
            this.cutDependencies = cutDependencies;
            this.dependencies = Objects.requireNonNull(dependencies, "dependencies");
            this.managedDependencies = Objects.requireNonNull(managedDependencies, "managedDependencies");
        }

        public Builder load() {
            this.load = true;
            return this;
        }

        public Builder doNotLoad() {
            this.load = false;
            return this;
        }

        public Builder applyManagedDependencies(boolean applyManagedDependencies) {
            this.applyManagedDependencies = applyManagedDependencies;
            return this;
        }

        public Builder cutDependencies(boolean cutDependencies) {
            this.cutDependencies = cutDependencies;
            return this;
        }

        public Builder withDependencies(List<Dependency> dependencies) {
            this.dependencies = new ArrayList<Dependency>(dependencies);
            return this;
        }

        public Builder withManagedDependencies(List<Dependency> managedDependencies) {
            this.managedDependencies = new ArrayList<Dependency>(managedDependencies);
            return this;
        }

        public ResolutionRoot build() {
            return new ResolutionRoot(this.artifact, this.load, this.applyManagedDependencies, this.cutDependencies, false, this.dependencies, this.managedDependencies);
        }
    }
}

