/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

public enum ResolutionScope {
    NONE(false, "none", Collections.emptySet(), Arrays.asList("compile", "system", "runtime", "provided", "test")),
    COMPILE(false, "compile", Arrays.asList("provided", "compile", "system"), Arrays.asList("provided", "test")),
    COMPILE_PLUS_RUNTIME(false, "compile+runtime", Arrays.asList("provided", "compile", "system", "runtime"), Arrays.asList("provided", "test")),
    RUNTIME(true, "runtime", Arrays.asList("compile", "runtime"), Arrays.asList("provided", "test")),
    RUNTIME_PLUS_SYSTEM(true, "runtime+system", Arrays.asList("compile", "runtime", "system"), Arrays.asList("provided", "test")),
    TEST(false, "test", Arrays.asList("compile", "system", "runtime", "provided", "test"), Arrays.asList("provided", "test"));

    private final boolean eliminateTest;
    private final String classpathType;
    private final Set<String> directInclude;
    private final Set<String> transitiveExclude;

    private ResolutionScope(boolean eliminateTest, String classpathType, Collection<String> directInclude, Collection<String> transitiveExclude) {
        this.eliminateTest = eliminateTest;
        this.classpathType = classpathType;
        this.directInclude = new HashSet<String>(directInclude);
        this.transitiveExclude = new HashSet<String>(transitiveExclude);
    }

    public boolean isEliminateTest() {
        return this.eliminateTest;
    }

    public Set<String> getDirectInclude() {
        return this.directInclude;
    }

    public Set<String> getTransitiveExclude() {
        return this.transitiveExclude;
    }

    public DependencyFilter getDependencyFilter() {
        return DependencyFilterUtils.classpathFilter((String[])new String[]{this.classpathType});
    }

    public static ResolutionScope parse(String value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value");
        try {
            return ResolutionScope.valueOf(value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("No such scope; available scopes are: " + Arrays.toString((Object[])ResolutionScope.values()), e);
        }
    }
}

