/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;

@FunctionalInterface
public interface Sink<T>
extends AutoCloseable {
    public void accept(T var1) throws IOException;

    default public void accept(Stream<T> stream) throws IOException {
        try {
            stream.forEach(t -> {
                try {
                    this.accept(t);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    default public void accept(Collection<T> things) throws IOException {
        Objects.requireNonNull(things, "things");
        try {
            for (T thing : things) {
                this.accept(thing);
            }
        }
        catch (IOException e) {
            this.cleanup(e);
            throw e;
        }
    }

    default public void cleanup(Exception e) {
    }

    @Override
    default public void close() throws Exception {
    }
}

