/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.input;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public final class StringSlurper {
    private StringSlurper() {
    }

    public static Collection<String> csv(String csv) {
        if (csv == null || csv.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(csv.split("[,;|]"));
    }

    public static Collection<String> slurp(String csv) throws IOException {
        if (csv == null || csv.trim().isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Path target = Path.of(csv, new String[0]).toAbsolutePath();
            if (Files.isRegularFile(target, new LinkOption[0]) && Files.size(target) < 5000000L) {
                return Files.readAllLines(target);
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        return StringSlurper.csv(csv);
    }
}

