/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.output.Marker;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

public class ArtifactConflictComparator {
    private final Output output;
    private final Function<Artifact, String> keyFactory;
    private final Map<String, Function<Artifact, String>> differentiators;

    public ArtifactConflictComparator(Output output, Function<Artifact, String> keyFactory, Map<String, Function<Artifact, String>> differentiators) {
        this.output = Objects.requireNonNull(output);
        this.keyFactory = Objects.requireNonNull(keyFactory);
        this.differentiators = Objects.requireNonNull(differentiators);
    }

    public void compare(Artifact artifact1, List<Artifact> a1, Artifact artifact2, List<Artifact> a2) {
        LinkedHashMap conflicts = new LinkedHashMap();
        a1.forEach(a -> {
            Map diff = conflicts.computeIfAbsent(this.keyFactory.apply((Artifact)a), k -> new LinkedHashMap());
            for (Map.Entry<String, Function<Artifact, String>> entry : this.differentiators.entrySet()) {
                diff.computeIfAbsent(entry.getKey(), k -> new LinkedHashMap()).computeIfAbsent(entry.getValue().apply((Artifact)a), k -> new LinkedHashSet()).add(a);
            }
        });
        a2.forEach(a -> {
            Map diff = conflicts.computeIfAbsent(this.keyFactory.apply((Artifact)a), k -> new LinkedHashMap());
            for (Map.Entry<String, Function<Artifact, String>> entry : this.differentiators.entrySet()) {
                diff.computeIfAbsent(entry.getKey(), k -> new LinkedHashMap()).computeIfAbsent(entry.getValue().apply((Artifact)a), k -> new LinkedHashSet()).add(a);
            }
        });
        LinkedHashSet differentiatorsWithConflicts = new LinkedHashSet();
        for (Map.Entry entry : conflicts.entrySet()) {
            ((Map)entry.getValue()).entrySet().stream().filter(e -> ((Map)e.getValue()).size() > 1).forEach(e -> differentiatorsWithConflicts.add((String)e.getKey()));
        }
        Marker marker = this.output.marker(this.output.getVerbosity());
        if (differentiatorsWithConflicts.isEmpty()) {
            this.output.tell(marker.outstanding("No conflicts exist for {} vs {}").toString(), ArtifactIdUtils.toId((Artifact)artifact1), ArtifactIdUtils.toId((Artifact)artifact2));
        } else {
            this.output.tell(marker.scary("Conflicts exist for {} vs {}").toString(), ArtifactIdUtils.toId((Artifact)artifact1), ArtifactIdUtils.toId((Artifact)artifact2));
            for (Map.Entry l1 : conflicts.entrySet()) {
                boolean keyShown = false;
                for (Map.Entry l2 : ((Map)l1.getValue()).entrySet()) {
                    if (!differentiatorsWithConflicts.contains(l2.getKey()) || ((Map)l2.getValue()).size() <= 1) continue;
                    if (!keyShown) {
                        this.output.tell("-- {}", marker.emphasize((String)l1.getKey()));
                        keyShown = true;
                    }
                    this.output.tell("     {}", marker.normal((String)l2.getKey()));
                    for (Map.Entry l3 : ((Map)l2.getValue()).entrySet()) {
                        if (!differentiatorsWithConflicts.contains(l2.getKey())) continue;
                        this.output.tell("      {} with {}", marker.bloody((String)l3.getKey()).toString(), marker.scary(((Set)l3.getValue()).stream().map(ArtifactIdUtils::toId).collect(Collectors.joining(", "))).toString());
                    }
                }
            }
        }
    }
}

