/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.output.Marker;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.jline.jansi.Ansi;

public class ArtifactListComparator {
    private final Output output;
    private final boolean unified;

    public ArtifactListComparator(Output output, boolean unified) {
        this.output = Objects.requireNonNull(output);
        this.unified = unified;
    }

    public void compare(Artifact a1root, List<Artifact> a1, Artifact a2root, List<Artifact> a2) {
        ArrayList<Artifact> a1Sa2 = new ArrayList<Artifact>(a1);
        a1Sa2.removeAll(a2);
        ArrayList<Artifact> a2Sa1 = new ArrayList<Artifact>(a2);
        a2Sa1.removeAll(a1);
        Marker marker = this.output.marker(this.output.getVerbosity());
        if (a1Sa2.isEmpty() && a2Sa1.isEmpty()) {
            this.output.tell(marker.outstanding("No differences found.").toString(), new Object[0]);
        } else if (this.unified) {
            LinkedHashMap umap = new LinkedHashMap();
            a1.forEach(a -> umap.computeIfAbsent(ArtifactIdUtils.toVersionlessId((Artifact)a), k -> new ArrayList()).add(a));
            a2.forEach(a -> umap.computeIfAbsent(ArtifactIdUtils.toVersionlessId((Artifact)a), k -> {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(null);
                return list;
            }).add(a));
            String diffSame = Ansi.ansi().fg(Ansi.Color.WHITE).a("   ").reset().toString();
            String diffModified = Ansi.ansi().fg(Ansi.Color.YELLOW).a("***").reset().toString();
            String diffAdded = Ansi.ansi().fg(Ansi.Color.GREEN).a("+++").reset().toString();
            String diffRemoved = Ansi.ansi().fg(Ansi.Color.RED).a("---").reset().toString();
            for (Map.Entry entry : umap.entrySet()) {
                Artifact right;
                Artifact left = (Artifact)((List)entry.getValue()).get(0);
                Artifact artifact = right = ((List)entry.getValue()).size() == 2 ? (Artifact)((List)entry.getValue()).get(1) : null;
                if (Objects.equals(left, right)) {
                    this.output.tell(diffSame + " " + marker.normal(ArtifactIdUtils.toId((Artifact)left)).toString(), new Object[0]);
                    continue;
                }
                if (left == null) {
                    this.output.tell(diffAdded + " " + marker.outstanding(ArtifactIdUtils.toId((Artifact)right)).toString(), new Object[0]);
                    continue;
                }
                if (right == null) {
                    this.output.tell(diffRemoved + " " + marker.bloody(ArtifactIdUtils.toId((Artifact)left)).toString(), new Object[0]);
                    continue;
                }
                this.output.tell(diffModified + " " + marker.normal(ArtifactIdUtils.toVersionlessId((Artifact)left)).toString() + " " + marker.bloody(left.getVersion()).toString() + " -> " + marker.bloody(right.getVersion()).toString(), new Object[0]);
            }
        } else {
            String diffSame = Ansi.ansi().fg(Ansi.Color.WHITE).a("   ").reset().toString();
            String diffAdded = Ansi.ansi().fg(Ansi.Color.GREEN).a("+++").reset().toString();
            String diffRemoved = Ansi.ansi().fg(Ansi.Color.RED).a("---").reset().toString();
            this.output.tell(marker.outstanding(String.format("Classpath of %s (in order)", ArtifactIdUtils.toId((Artifact)a1root))).toString(), new Object[0]);
            a1.forEach(a -> {
                if (a2.contains(a)) {
                    this.output.tell(diffSame + " " + marker.normal(ArtifactIdUtils.toId((Artifact)a)).toString(), new Object[0]);
                } else {
                    this.output.tell(diffRemoved + " " + marker.bloody(ArtifactIdUtils.toId((Artifact)a)).toString(), new Object[0]);
                }
            });
            this.output.tell(marker.outstanding(String.format("Classpath of %s (in order)", ArtifactIdUtils.toId((Artifact)a2root))).toString(), new Object[0]);
            a2.forEach(a -> {
                if (a1.contains(a)) {
                    this.output.tell(diffSame + " " + marker.normal(ArtifactIdUtils.toId((Artifact)a)).toString(), new Object[0]);
                } else {
                    this.output.tell(diffAdded + " " + marker.outstanding(ArtifactIdUtils.toId((Artifact)a)).toString(), new Object[0]);
                }
            });
        }
    }
}

