/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.ArtifactMapper;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactNameMapper;
import eu.maveniverse.maven.toolbox.shared.Sink;
import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.internal.DeployingSink;
import eu.maveniverse.maven.toolbox.shared.internal.DirectorySink;
import eu.maveniverse.maven.toolbox.shared.internal.InstallingSink;
import eu.maveniverse.maven.toolbox.shared.internal.ModuleDescriptorExtractingSink;
import eu.maveniverse.maven.toolbox.shared.internal.PurgingSink;
import eu.maveniverse.maven.toolbox.shared.internal.SpecParser;
import eu.maveniverse.maven.toolbox.shared.internal.ToolboxCommandoImpl;
import eu.maveniverse.maven.toolbox.shared.internal.UnpackSink;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.checksum.Sha1ChecksumAlgorithmFactory;
import org.eclipse.aether.internal.impl.checksum.Sha512ChecksumAlgorithmFactory;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmHelper;

public final class ArtifactSinks {
    private ArtifactSinks() {
    }

    public static Artifacts.Sink build(Map<String, ?> properties, ToolboxCommandoImpl tc, boolean dryRun, String spec) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(tc, "tc");
        Objects.requireNonNull(spec, "spec");
        ArtifactSinkBuilder builder = new ArtifactSinkBuilder(properties, tc, dryRun);
        try {
            SpecParser.parse(spec).accept(builder);
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid artifact sink spec: " + spec, e);
        }
    }

    public static NullArtifactSink nullArtifactSink() {
        return new NullArtifactSink();
    }

    public static NonClosingArtifactSink nonClosingArtifactSink(Sink<Artifact> delegate) {
        Objects.requireNonNull(delegate, "delegate");
        return new NonClosingArtifactSink(delegate);
    }

    public static MatchingArtifactSink matchingArtifactSink(Predicate<Artifact> artifactMatcher, Sink<Artifact> delegate) {
        Objects.requireNonNull(artifactMatcher, "artifactMatcher");
        Objects.requireNonNull(delegate, "delegate");
        return new MatchingArtifactSink(artifactMatcher, delegate);
    }

    public static MappingArtifactSink mappingArtifactSink(Function<Artifact, Artifact> artifactMapper, Sink<Artifact> delegate) {
        Objects.requireNonNull(artifactMapper, "artifactMapper");
        Objects.requireNonNull(delegate, "delegate");
        return new MappingArtifactSink(artifactMapper, delegate);
    }

    public static CountingArtifactSink countingArtifactSink() {
        return new CountingArtifactSink();
    }

    public static CollectingArtifactSink collectingArtifactSink() {
        return new CollectingArtifactSink();
    }

    public static SizingArtifactSink sizingArtifactSink() {
        return new SizingArtifactSink();
    }

    public static ChecksumArtifactSink checksumArtifactSink(ChecksumAlgorithmFactory ... factories) {
        return new ChecksumArtifactSink(factories.length == 0 ? List.of(new Sha1ChecksumAlgorithmFactory(), new Sha512ChecksumAlgorithmFactory()) : Arrays.asList(factories));
    }

    @SafeVarargs
    public static TeeArtifactSink teeArtifactSink(Sink<Artifact> ... artifactSinks) {
        return ArtifactSinks.teeArtifactSink(Arrays.asList(artifactSinks));
    }

    public static TeeArtifactSink teeArtifactSink(Collection<? extends Sink<Artifact>> artifactSinks) {
        Objects.requireNonNull(artifactSinks, "artifactSinks");
        return new TeeArtifactSink(artifactSinks);
    }

    public static StatArtifactSink statArtifactSink(int level, boolean list, boolean details, Output output) {
        return new StatArtifactSink(level, list, details, output);
    }

    public static LoggingArtifactSink loggingArtifactSink(Output output) {
        return new LoggingArtifactSink(output);
    }

    static class ArtifactSinkBuilder
    extends SpecParser.Builder {
        private final ToolboxCommandoImpl tc;
        private final boolean dryRun;

        public ArtifactSinkBuilder(Map<String, ?> properties, ToolboxCommandoImpl tc, boolean dryRun) {
            super(properties);
            this.tc = tc;
            this.dryRun = dryRun;
        }

        @Override
        public boolean visitEnter(SpecParser.Node node) {
            return super.visitEnter(node) && !"flat".equals(node.getValue()) && !"matching".equals(node.getValue()) && !"mapping".equals(node.getValue()) && !"unpack".equals(node.getValue());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void processOp(SpecParser.Node node) {
            switch (node.getValue()) {
                case "null": {
                    this.params.add(ArtifactSinks.nullArtifactSink());
                    return;
                }
                case "counting": {
                    this.params.add(ArtifactSinks.countingArtifactSink());
                    return;
                }
                case "sizing": {
                    this.params.add(ArtifactSinks.sizingArtifactSink());
                    return;
                }
                case "logging": {
                    this.params.add(ArtifactSinks.loggingArtifactSink(this.tc.output()));
                    return;
                }
                case "stat": {
                    boolean details;
                    boolean list;
                    if (node.getChildren().isEmpty()) {
                        list = true;
                        details = true;
                    } else if (node.getChildren().size() == 1) {
                        list = true;
                        details = this.booleanParam(node.getChildren().get(0).getValue());
                    } else {
                        if (node.getChildren().size() != 2) throw new IllegalArgumentException("op stat accepts only 0..2 argument");
                        list = this.booleanParam(node.getChildren().get(0).getValue());
                        details = this.booleanParam(node.getChildren().get(1).getValue());
                    }
                    this.params.add(ArtifactSinks.statArtifactSink(0, list, details, this.tc.output()));
                    return;
                }
                case "tee": {
                    this.params.add(ArtifactSinks.teeArtifactSink(this.typedParams(Artifacts.Sink.class, node.getValue())));
                    return;
                }
                case "nonClosing": {
                    this.params.add(ArtifactSinks.nonClosingArtifactSink(this.typedParam(Artifacts.Sink.class, node.getValue())));
                    return;
                }
                case "flat": {
                    try {
                        Path p0;
                        ArtifactNameMapper p1;
                        if (node.getChildren().size() == 2) {
                            ArtifactNameMapper.ArtifactNameMapperBuilder mapperBuilder = new ArtifactNameMapper.ArtifactNameMapperBuilder(this.properties);
                            node.getChildren().get(1).accept(mapperBuilder);
                            p1 = mapperBuilder.build();
                            p0 = this.tc.basedir().resolve(node.getChildren().get(0).getValue());
                        } else {
                            if (node.getChildren().size() != 1) throw new IllegalArgumentException("op flat accepts only 1..2 argument");
                            p1 = ArtifactNameMapper.AbVCE();
                            p0 = this.tc.basedir().resolve(node.getChildren().get(0).getValue());
                        }
                        this.params.add(DirectorySink.flat(this.tc.output(), p0, p1, this.dryRun));
                        node.getChildren().clear();
                        return;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                case "repository": {
                    try {
                        Path p0 = this.tc.basedir().resolve(this.stringParam(node.getValue()));
                        this.params.add(DirectorySink.repository(this.tc.output(), p0, this.dryRun));
                        return;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                case "install": {
                    if (node.getChildren().isEmpty()) {
                        this.params.add(InstallingSink.installing(this.tc.output(), this.tc.repositorySystem(), this.tc.session(), this.dryRun));
                        return;
                    }
                    if (node.getChildren().size() != 1) throw new IllegalArgumentException("op install accepts only 0..1 argument");
                    String p0 = this.stringParam(node.getValue());
                    Path altLocalRepository = this.tc.basedir().resolve(p0);
                    LocalRepository localRepository = new LocalRepository(altLocalRepository.toFile());
                    LocalRepositoryManager lrm = this.tc.repositorySystem().newLocalRepositoryManager(this.tc.session(), localRepository);
                    DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(this.tc.session());
                    session.setLocalRepositoryManager(lrm);
                    this.params.add(InstallingSink.installing(this.tc.output(), this.tc.repositorySystem(), (RepositorySystemSession)session, this.dryRun));
                    return;
                }
                case "deploy": {
                    this.params.add(DeployingSink.deploying(this.tc.output(), this.tc.repositorySystem(), this.tc.session(), this.tc.parseRemoteRepository(this.stringParam(node.getValue())), this.dryRun));
                    return;
                }
                case "purge": {
                    this.params.add(PurgingSink.purging(this.tc.output(), this.tc.repositorySystem(), this.tc.session(), this.stringParams(node.getValue()).stream().map(this.tc::parseRemoteRepository).collect(Collectors.toList()), this.dryRun));
                    return;
                }
                case "unpack": {
                    try {
                        if (node.getChildren().size() == 1) {
                            Path p0 = this.tc.basedir().resolve(node.getChildren().get(0).getValue());
                            this.params.add(UnpackSink.unpack(this.tc.output(), p0, ArtifactNameMapper.ACVE(), true, this.dryRun));
                        } else {
                            if (node.getChildren().size() != 2) throw new IllegalArgumentException("op unpack accepts only 1..2 argument");
                            ArtifactNameMapper.ArtifactNameMapperBuilder mapperBuilder = new ArtifactNameMapper.ArtifactNameMapperBuilder(this.properties);
                            node.getChildren().get(1).accept(mapperBuilder);
                            ArtifactNameMapper p1 = mapperBuilder.build();
                            Path p0 = this.tc.basedir().resolve(node.getChildren().get(0).getValue());
                            this.params.add(UnpackSink.unpack(this.tc.output(), p0, p1, true, this.dryRun));
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    node.getChildren().clear();
                    return;
                }
                case "matching": {
                    if (node.getChildren().size() != 2) {
                        throw new IllegalArgumentException("op matching accepts only 2 argument");
                    }
                    ArtifactMatcher.ArtifactMatcherBuilder matcherBuilder = new ArtifactMatcher.ArtifactMatcherBuilder(this.properties);
                    node.getChildren().get(0).accept(matcherBuilder);
                    ArtifactMatcher matcher = matcherBuilder.build();
                    ArtifactSinkBuilder sinkBuilder = new ArtifactSinkBuilder(this.properties, this.tc, this.dryRun);
                    node.getChildren().get(1).accept(sinkBuilder);
                    Artifacts.Sink delegate = sinkBuilder.build();
                    this.params.add(ArtifactSinks.matchingArtifactSink(matcher, delegate));
                    node.getChildren().clear();
                    return;
                }
                case "mapping": {
                    if (node.getChildren().size() != 2) {
                        throw new IllegalArgumentException("op mapping accepts only 2 argument");
                    }
                    ArtifactMapper.ArtifactMapperBuilder mapperBuilder = new ArtifactMapper.ArtifactMapperBuilder(this.properties);
                    node.getChildren().get(0).accept(mapperBuilder);
                    ArtifactMapper mapper = mapperBuilder.build();
                    ArtifactSinkBuilder sinkBuilder = new ArtifactSinkBuilder(this.properties, this.tc, this.dryRun);
                    node.getChildren().get(1).accept(sinkBuilder);
                    Artifacts.Sink delegate = sinkBuilder.build();
                    this.params.add(ArtifactSinks.mappingArtifactSink(mapper, delegate));
                    node.getChildren().clear();
                    return;
                }
                case "moduleDescriptor": {
                    this.params.add(new ModuleDescriptorExtractingSink(this.tc.output()));
                    return;
                }
                default: {
                    throw new IllegalArgumentException("unknown op " + node.getValue());
                }
            }
        }

        public Artifacts.Sink build() {
            return this.build(Artifacts.Sink.class);
        }
    }

    public static class NullArtifactSink
    implements Artifacts.Sink {
        private NullArtifactSink() {
        }

        @Override
        public void accept(Collection<Artifact> artifacts) {
        }

        @Override
        public void accept(Artifact artifact) {
        }
    }

    public static class NonClosingArtifactSink
    extends DelegatingArtifactSink {
        private NonClosingArtifactSink(Sink<Artifact> delegate) {
            super(delegate);
        }

        @Override
        public void close() {
        }
    }

    public static class MatchingArtifactSink
    extends DelegatingArtifactSink {
        private final Predicate<Artifact> artifactMatcher;

        private MatchingArtifactSink(Predicate<Artifact> artifactMatcher, Sink<Artifact> delegate) {
            super(delegate);
            this.artifactMatcher = artifactMatcher;
        }

        @Override
        public void accept(Collection<Artifact> artifacts) throws IOException {
            super.accept(artifacts.stream().filter(this.artifactMatcher).collect(Collectors.toList()));
        }

        @Override
        public void accept(Artifact artifact) throws IOException {
            if (this.artifactMatcher.test(artifact)) {
                super.accept(artifact);
            }
        }
    }

    public static class MappingArtifactSink
    extends DelegatingArtifactSink {
        private final Function<Artifact, Artifact> artifactMapper;

        private MappingArtifactSink(Function<Artifact, Artifact> artifactMapper, Sink<Artifact> delegate) {
            super(delegate);
            this.artifactMapper = artifactMapper;
        }

        @Override
        public void accept(Collection<Artifact> artifacts) throws IOException {
            super.accept(artifacts.stream().map(this.artifactMapper).collect(Collectors.toList()));
        }

        @Override
        public void accept(Artifact artifact) throws IOException {
            super.accept(this.artifactMapper.apply(artifact));
        }
    }

    public static class CountingArtifactSink
    implements Artifacts.Sink {
        private final LongAdder counter = new LongAdder();

        private CountingArtifactSink() {
        }

        @Override
        public void accept(Artifact artifact) {
            this.counter.increment();
        }

        public int count() {
            return this.counter.intValue();
        }
    }

    public static class CollectingArtifactSink
    implements Artifacts.Sink {
        private final CopyOnWriteArrayList<Artifact> artifacts = new CopyOnWriteArrayList();

        private CollectingArtifactSink() {
        }

        @Override
        public void accept(Artifact artifact) {
            this.artifacts.add(artifact);
        }

        public List<Artifact> collect() {
            return this.artifacts;
        }
    }

    public static class SizingArtifactSink
    implements Artifacts.Sink {
        private final LongAdder size = new LongAdder();

        private SizingArtifactSink() {
        }

        @Override
        public void accept(Artifact artifact) throws IOException {
            Path path;
            Path path2 = path = artifact.getFile() != null ? artifact.getFile().toPath() : null;
            if (path != null && Files.exists(path, new LinkOption[0])) {
                this.size.add(Files.size(path));
            }
        }

        public long size() {
            return this.size.sum();
        }
    }

    public static class ChecksumArtifactSink
    implements Artifacts.Sink {
        private final ConcurrentMap<Artifact, Map<String, String>> checksums = new ConcurrentHashMap<Artifact, Map<String, String>>();
        private final List<ChecksumAlgorithmFactory> algorithmFactories;

        private ChecksumArtifactSink(List<ChecksumAlgorithmFactory> algorithmFactories) {
            Objects.requireNonNull(algorithmFactories, "algorithmFactories");
            this.algorithmFactories = algorithmFactories;
        }

        @Override
        public void accept(Artifact artifact) throws IOException {
            Path path;
            Path path2 = path = artifact.getFile() != null ? artifact.getFile().toPath() : null;
            if (path != null && Files.exists(path, new LinkOption[0])) {
                this.checksums.put(artifact, ChecksumAlgorithmHelper.calculate((File)path.toFile(), this.algorithmFactories));
            }
        }

        public Map<String, String> checksums(Artifact artifact) {
            return this.checksums.getOrDefault(artifact, Collections.emptyMap());
        }
    }

    public static class TeeArtifactSink
    implements Artifacts.Sink {
        private final Collection<Sink<Artifact>> artifactSinks;

        private TeeArtifactSink(Collection<? extends Sink<Artifact>> artifactSinks) {
            this.artifactSinks = Collections.unmodifiableCollection(new ArrayList<Sink<Artifact>>(artifactSinks));
        }

        @Override
        public void accept(Collection<Artifact> artifacts) throws IOException {
            for (Sink<Artifact> sink : this.artifactSinks) {
                sink.accept(artifacts);
            }
        }

        @Override
        public void accept(Artifact artifact) throws IOException {
            for (Sink<Artifact> sink : this.artifactSinks) {
                sink.accept(artifact);
            }
        }

        @Override
        public void cleanup(Exception e) {
            for (Sink<Artifact> sink : this.artifactSinks) {
                sink.cleanup(e);
            }
        }

        @Override
        public void close() throws Exception {
            for (Sink<Artifact> sink : this.artifactSinks) {
                sink.close();
            }
        }
    }

    public static class StatArtifactSink
    implements Artifacts.Sink {
        private final int level;
        private final boolean list;
        private final boolean details;
        private final Output output;
        private final CopyOnWriteArrayList<Artifact> seen = new CopyOnWriteArrayList();
        private final CountingArtifactSink countingArtifactSink = new CountingArtifactSink();
        private final SizingArtifactSink sizingArtifactSink = new SizingArtifactSink();
        private final ModuleDescriptorExtractingSink moduleDescriptorExtractingSink;
        private final ChecksumArtifactSink checksumArtifactSink;

        private StatArtifactSink(int level, boolean list, boolean details, Output output) {
            this.level = level;
            this.list = list;
            this.details = details;
            this.output = Objects.requireNonNull(output, "output");
            this.moduleDescriptorExtractingSink = details ? new ModuleDescriptorExtractingSink(output) : null;
            this.checksumArtifactSink = details ? ArtifactSinks.checksumArtifactSink(new ChecksumAlgorithmFactory[0]) : null;
        }

        public boolean isList() {
            return this.list;
        }

        public boolean isDetails() {
            return this.details;
        }

        @Override
        public void accept(Artifact artifact) throws IOException {
            this.seen.add(artifact);
            this.countingArtifactSink.accept(artifact);
            this.sizingArtifactSink.accept(artifact);
            if (this.details) {
                this.moduleDescriptorExtractingSink.accept(artifact);
                this.checksumArtifactSink.accept(artifact);
            }
        }

        public List<Artifact> getSeenArtifacts() {
            return this.seen;
        }

        @Override
        public void close() throws Exception {
            Object indent = "";
            for (int i = 0; i < this.level; ++i) {
                indent = (String)indent + "  ";
            }
            this.countingArtifactSink.close();
            this.sizingArtifactSink.close();
            if (this.details) {
                this.moduleDescriptorExtractingSink.close();
            }
            if (this.list) {
                this.output.tell("{}------------------------------", indent);
                for (Artifact artifact : this.seen) {
                    this.output.tell("{}{}", indent, artifact);
                    if (!this.details) continue;
                    ModuleDescriptorExtractingSink.ModuleDescriptor descriptor = this.moduleDescriptorExtractingSink.getModuleDescriptor(artifact);
                    String moduleInfo = "";
                    if (descriptor != null) {
                        moduleInfo = this.moduleDescriptorExtractingSink.formatString(descriptor);
                    }
                    Map<String, String> checksums = this.checksumArtifactSink.checksums(artifact);
                    this.output.tell("{} -- {}", indent, moduleInfo);
                    if (checksums != null && !checksums.isEmpty()) {
                        for (Map.Entry<String, String> checksum : checksums.entrySet()) {
                            this.output.tell("{} -- {}: {}", indent, checksum.getKey(), checksum.getValue());
                        }
                    }
                    if (artifact.getProperty("origin", null) == null) continue;
                    this.output.tell("{} -- Origin: {}", indent, artifact.getProperty("origin", null));
                }
                this.output.tell("{}------------------------------", indent);
            }
            this.output.doTell("{}Total of {} artifacts ({})", indent, this.countingArtifactSink.count(), ToolboxCommandoImpl.humanReadableByteCountBin(this.sizingArtifactSink.size()));
            this.output.tell("{}------------------------------", indent);
        }
    }

    public static class LoggingArtifactSink
    implements Artifacts.Sink {
        private final Output output;

        private LoggingArtifactSink(Output output) {
            this.output = Objects.requireNonNull(output, "output");
        }

        @Override
        public void accept(Artifact artifact) throws IOException {
            this.output.doTell(artifact.toString(), new Object[0]);
        }
    }

    public static abstract class DelegatingArtifactSink
    implements Artifacts.Sink {
        private final Sink<Artifact> delegate;

        public DelegatingArtifactSink(Sink<Artifact> delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        @Override
        public void accept(Collection<Artifact> artifacts) throws IOException {
            this.delegate.accept(artifacts);
        }

        @Override
        public void accept(Artifact artifact) throws IOException {
            this.delegate.accept(artifact);
        }

        @Override
        public void cleanup(Exception e) {
            this.delegate.cleanup(e);
        }

        @Override
        public void close() throws Exception {
            this.delegate.close();
        }
    }
}

