/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.ArtifactMapper;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.input.StringSlurper;
import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.internal.DirectorySource;
import eu.maveniverse.maven.toolbox.shared.internal.LocalRepositorySource;
import eu.maveniverse.maven.toolbox.shared.internal.SpecParser;
import eu.maveniverse.maven.toolbox.shared.internal.ToolboxCommandoImpl;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public final class ArtifactSources {
    private ArtifactSources() {
    }

    public static Artifacts.Source build(Map<String, ?> properties, ToolboxCommandoImpl tc, String spec) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(tc, "tc");
        Objects.requireNonNull(spec, "spec");
        ArtifactSourceBuilder builder = new ArtifactSourceBuilder(properties, tc);
        try {
            SpecParser.parse(spec).accept(builder);
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid artifact source spec:" + spec, e);
        }
    }

    public static NullArtifactSource nullArtifactSource() {
        return new NullArtifactSource();
    }

    public static MatchingArtifactSource matchingArtifactSource(Predicate<Artifact> artifactMatcher, Artifacts.Source delegate) {
        Objects.requireNonNull(artifactMatcher, "artifactMatcher");
        Objects.requireNonNull(delegate, "delegate");
        return new MatchingArtifactSource(artifactMatcher, delegate);
    }

    public static MappingArtifactSource mappingArtifactSource(Function<Artifact, Artifact> artifactMapper, Artifacts.Source delegate) {
        Objects.requireNonNull(artifactMapper, "artifactMapper");
        Objects.requireNonNull(delegate, "delegate");
        return new MappingArtifactSource(artifactMapper, delegate);
    }

    public static Artifacts.Source gavArtifactSource(String gav) {
        Objects.requireNonNull(gav, "gav");
        return new GavArtifactSource(gav);
    }

    public static Artifacts.Source gavsArtifactSource(String gavs) {
        Objects.requireNonNull(gavs, "gavs");
        return new GavsArtifactSource(gavs);
    }

    public static Artifacts.Source concatArtifactSource(Collection<Artifacts.Source> sources) {
        Objects.requireNonNull(sources, "sources");
        return new ConcatArtifactSource(sources);
    }

    public static Artifacts.Source resolveArtifactSource(Artifacts.Source delegate, ToolboxCommandoImpl toolboxCommando) {
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(toolboxCommando, "toolboxCommando");
        return new ResolveArtifactSource(delegate, toolboxCommando);
    }

    public static Artifacts.Source resolveTransitiveArtifactSource(Artifacts.Source delegate, ToolboxCommandoImpl toolboxCommando, ResolutionScope scope) {
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(toolboxCommando, "toolboxCommando");
        Objects.requireNonNull(scope, "scope");
        return new ResolveTransitiveArtifactSource(delegate, toolboxCommando, scope);
    }

    static class ArtifactSourceBuilder
    extends SpecParser.Builder {
        private final ToolboxCommandoImpl tc;

        public ArtifactSourceBuilder(Map<String, ?> properties, ToolboxCommandoImpl tc) {
            super(properties);
            this.tc = tc;
        }

        @Override
        public boolean visitEnter(SpecParser.Node node) {
            return super.visitEnter(node) && !"matching".equals(node.getValue()) && !"mapping".equals(node.getValue()) && !"concat".equals(node.getValue()) && !"resolve".equals(node.getValue()) && !"resolveTransitive".equals(node.getValue());
        }

        @Override
        protected void processOp(SpecParser.Node node) {
            switch (node.getValue()) {
                case "null": {
                    this.params.add(ArtifactSources.nullArtifactSource());
                    break;
                }
                case "gav": {
                    String gav = this.stringParam(node.getValue());
                    this.params.add(ArtifactSources.gavArtifactSource(gav));
                    break;
                }
                case "gavs": {
                    String gav = this.stringParam(node.getValue());
                    this.params.add(ArtifactSources.gavsArtifactSource(gav));
                    break;
                }
                case "concat": {
                    ArrayList<Artifacts.Source> sources = new ArrayList<Artifacts.Source>();
                    for (SpecParser.Node sourceNode : node.getChildren()) {
                        ArtifactSourceBuilder builder = new ArtifactSourceBuilder(this.properties, this.tc);
                        sourceNode.accept(builder);
                        sources.add(builder.build());
                    }
                    this.params.add(ArtifactSources.concatArtifactSource(sources));
                    break;
                }
                case "resolve": {
                    if (node.getChildren().size() != 1) {
                        throw new IllegalArgumentException("op resolve accepts only 1 argument");
                    }
                    ArtifactSourceBuilder builder = new ArtifactSourceBuilder(this.properties, this.tc);
                    node.getChildren().get(0).accept(builder);
                    this.params.add(ArtifactSources.resolveArtifactSource(builder.build(), this.tc));
                    break;
                }
                case "resolveTransitive": {
                    if (node.getChildren().size() == 1) {
                        ArtifactSourceBuilder builder = new ArtifactSourceBuilder(this.properties, this.tc);
                        node.getChildren().get(0).accept(builder);
                        this.params.add(ArtifactSources.resolveTransitiveArtifactSource(builder.build(), this.tc, ResolutionScope.RUNTIME));
                        break;
                    }
                    if (node.getChildren().size() == 2) {
                        ArtifactSourceBuilder builder = new ArtifactSourceBuilder(this.properties, this.tc);
                        node.getChildren().get(0).accept(builder);
                        this.params.add(ArtifactSources.resolveTransitiveArtifactSource(builder.build(), this.tc, ResolutionScope.parse(node.getChildren().get(1).getValue())));
                        break;
                    }
                    throw new IllegalArgumentException("op resolveTransitive accepts only 1 or 2 argument");
                }
                case "directory": {
                    Path p0 = this.tc.basedir().resolve(this.stringParam(node.getValue()));
                    this.params.add(DirectorySource.directory(p0));
                    break;
                }
                case "sessionLocalRepository": {
                    this.params.add(LocalRepositorySource.local(this.tc.session().getLocalRepository().getBasedir().toPath()));
                    break;
                }
                case "localRepository": {
                    Path p0 = this.tc.basedir().resolve(this.stringParam(node.getValue()));
                    this.params.add(LocalRepositorySource.local(p0));
                    break;
                }
                case "recorder": {
                    this.params.add(this.tc.recorder());
                    break;
                }
                case "matching": {
                    if (node.getChildren().size() != 2) {
                        throw new IllegalArgumentException("op matching accepts only 2 argument");
                    }
                    ArtifactMatcher.ArtifactMatcherBuilder matcherBuilder = new ArtifactMatcher.ArtifactMatcherBuilder(this.properties);
                    node.getChildren().get(0).accept(matcherBuilder);
                    ArtifactMatcher matcher = matcherBuilder.build();
                    ArtifactSourceBuilder sourceBuilder = new ArtifactSourceBuilder(this.properties, this.tc);
                    node.getChildren().get(1).accept(sourceBuilder);
                    Artifacts.Source delegate = sourceBuilder.build();
                    this.params.add(ArtifactSources.matchingArtifactSource(matcher, delegate));
                    node.getChildren().clear();
                    break;
                }
                case "mapping": {
                    if (node.getChildren().size() != 2) {
                        throw new IllegalArgumentException("op mapping accepts only 2 argument");
                    }
                    ArtifactMapper.ArtifactMapperBuilder mapperBuilder = new ArtifactMapper.ArtifactMapperBuilder(this.properties);
                    node.getChildren().get(0).accept(mapperBuilder);
                    ArtifactMapper mapper = mapperBuilder.build();
                    ArtifactSourceBuilder sourceBuilder = new ArtifactSourceBuilder(this.properties, this.tc);
                    node.getChildren().get(1).accept(sourceBuilder);
                    Artifacts.Source delegate = sourceBuilder.build();
                    this.params.add(ArtifactSources.mappingArtifactSource(mapper, delegate));
                    node.getChildren().clear();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown op " + node.getValue());
                }
            }
        }

        public Artifacts.Source build() {
            return this.build(Artifacts.Source.class);
        }
    }

    public static class NullArtifactSource
    implements Artifacts.Source {
        private NullArtifactSource() {
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            return Stream.empty();
        }
    }

    public static class MatchingArtifactSource
    extends DelegatingArtifactSource {
        private final Predicate<Artifact> artifactMatcher;

        private MatchingArtifactSource(Predicate<Artifact> artifactMatcher, Artifacts.Source delegate) {
            super(delegate);
            this.artifactMatcher = artifactMatcher;
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            return super.get().filter(this.artifactMatcher);
        }
    }

    public static class MappingArtifactSource
    extends DelegatingArtifactSource {
        private final Function<Artifact, Artifact> artifactMapper;

        private MappingArtifactSource(Function<Artifact, Artifact> artifactMapper, Artifacts.Source delegate) {
            super(delegate);
            this.artifactMapper = artifactMapper;
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            return super.get().map(this.artifactMapper);
        }
    }

    public static class GavArtifactSource
    implements Artifacts.Source {
        private final String gav;

        private GavArtifactSource(String gav) {
            this.gav = gav;
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            return Stream.of(new DefaultArtifact(this.gav));
        }
    }

    public static class GavsArtifactSource
    implements Artifacts.Source {
        private final String gavs;

        private GavsArtifactSource(String gavs) {
            this.gavs = gavs;
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            return StringSlurper.slurp(this.gavs).stream().map(DefaultArtifact::new);
        }
    }

    public static class ConcatArtifactSource
    implements Artifacts.Source {
        private final Collection<Artifacts.Source> sources;

        private ConcatArtifactSource(Collection<Artifacts.Source> sources) {
            this.sources = sources;
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            Stream result = null;
            for (Artifacts.Source source : this.sources) {
                if (result == null) {
                    result = source.get();
                    continue;
                }
                result = Stream.concat(result, source.get());
            }
            return result;
        }

        @Override
        public void close() throws Exception {
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            this.sources.forEach(s -> {
                try {
                    s.close();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            });
            if (!exceptions.isEmpty()) {
                Exception e = new Exception("Could not close concat() sources: " + String.valueOf(exceptions));
                exceptions.forEach(e::addSuppressed);
                throw e;
            }
        }
    }

    public static class ResolveArtifactSource
    extends DelegatingArtifactSource {
        private final ToolboxCommandoImpl toolboxCommando;

        private ResolveArtifactSource(Artifacts.Source delegate, ToolboxCommandoImpl toolboxCommando) {
            super(delegate);
            this.toolboxCommando = toolboxCommando;
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            return super.get().map(a -> {
                try {
                    ArtifactResult ar = this.toolboxCommando.toolboxResolver.resolveArtifact((Artifact)a);
                    if (ar.isResolved()) {
                        a = ToolboxCommandoImpl.origin(ar.getArtifact(), ar.getRepository());
                    } else {
                        this.toolboxCommando.output.warn("Unable to resolve artifact {}", ar.getArtifact(), ar.getExceptions());
                        a = null;
                    }
                }
                catch (ArtifactResolutionException e) {
                    throw new RuntimeException(e);
                }
                return a;
            }).filter(Objects::nonNull);
        }
    }

    public static class ResolveTransitiveArtifactSource
    extends DelegatingArtifactSource {
        private final ToolboxCommandoImpl toolboxCommando;
        private final ResolutionScope scope;

        private ResolveTransitiveArtifactSource(Artifacts.Source delegate, ToolboxCommandoImpl toolboxCommando, ResolutionScope scope) {
            super(delegate);
            this.toolboxCommando = toolboxCommando;
            this.scope = scope;
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            return super.get().flatMap(a -> {
                try {
                    return this.toolboxCommando.toolboxResolver.resolve(this.scope, this.toolboxCommando.toolboxResolver.loadRoot(ResolutionRoot.ofLoaded(a).build())).getArtifactResults().stream().peek(ar -> {
                        if (!ar.isResolved()) {
                            this.toolboxCommando.output.warn("Unable to resolve artifact {}", ar.getArtifact(), ar.getExceptions());
                        }
                    }).filter(ArtifactResult::isResolved).map(r -> ToolboxCommandoImpl.origin(r.getArtifact(), r.getRepository()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static abstract class DelegatingArtifactSource
    implements Artifacts.Source {
        private final Artifacts.Source delegate;

        public DelegatingArtifactSource(Artifacts.Source delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        @Override
        public Stream<Artifact> get() throws IOException {
            return this.delegate.get();
        }

        @Override
        public void close() throws Exception {
            this.delegate.close();
        }
    }
}

