/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.internal.DependencyGraphDumper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;

public class DependencyGraphComparator
implements DependencyVisitor {
    private final Consumer<String> consumer;
    private final List<Function<DependencyNode, String>> decorators;
    private final DependencyGraphDumper.LineFormatter lineFormatter;
    private Deque<DependencyNode> nodes;
    private int cmp;

    public DependencyGraphComparator(Consumer<String> consumer) {
        this(consumer, DependencyGraphDumper.defaultsWith(new Function[0]));
    }

    public DependencyGraphComparator(Consumer<String> consumer, Collection<Function<DependencyNode, String>> decorators) {
        this(consumer, decorators, new DependencyGraphDumper.LineFormatter());
    }

    public DependencyGraphComparator(Consumer<String> consumer, Collection<Function<DependencyNode, String>> decorators, DependencyGraphDumper.LineFormatter lineFormatter) {
        this.consumer = Objects.requireNonNull(consumer);
        this.decorators = new ArrayList<Function<DependencyNode, String>>(decorators);
        this.lineFormatter = Objects.requireNonNull(lineFormatter);
    }

    public void compare(DependencyNode root1, DependencyNode root2) {
        ArrayDeque ns1 = new ArrayDeque();
        ArrayDeque ns2 = new ArrayDeque();
        ns1.push(new ArrayDeque<DependencyNode>(List.of(root1)));
        ns2.push(new ArrayDeque<DependencyNode>(List.of(root2)));
        while (!ns1.isEmpty() || !ns2.isEmpty()) {
            DependencyNode current;
            ArrayDeque path;
            if (ns1.isEmpty()) {
                this.cmp = 1;
                while (!ns2.isEmpty()) {
                    path = (ArrayDeque)ns2.pop();
                    current = (DependencyNode)path.pop();
                    this.nodes = path;
                    current.accept((DependencyVisitor)this);
                }
                return;
            }
            if (ns2.isEmpty()) {
                this.cmp = -1;
                while (!ns1.isEmpty()) {
                    path = (ArrayDeque)ns1.pop();
                    current = (DependencyNode)path.pop();
                    this.nodes = path;
                    current.accept((DependencyVisitor)this);
                }
                return;
            }
            ArrayDeque path1 = (ArrayDeque)ns1.pop();
            ArrayDeque path2 = (ArrayDeque)ns2.pop();
            DependencyNode dn1 = (DependencyNode)path1.peek();
            DependencyNode dn2 = (DependencyNode)path2.peek();
            if (Objects.equals(dn1.getArtifact(), dn2.getArtifact())) {
                this.consumer.accept(this.lineFormatter.formatLine(0, path1, this.decorators));
            } else {
                this.consumer.accept(this.lineFormatter.formatLine(-1, path1, this.decorators));
                this.consumer.accept(this.lineFormatter.formatLine(1, path2, this.decorators));
            }
            ArrayList children1 = new ArrayList(dn1.getChildren());
            Collections.reverse(children1);
            for (DependencyNode child : children1) {
                ArrayDeque<DependencyNode> path3 = new ArrayDeque<DependencyNode>(path1);
                path3.push(child);
                ns1.push(path3);
            }
            ArrayList children2 = new ArrayList(dn2.getChildren());
            Collections.reverse(children2);
            for (DependencyNode child : children2) {
                ArrayDeque<DependencyNode> path4 = new ArrayDeque<DependencyNode>(path2);
                path4.push(child);
                ns2.push(path4);
            }
        }
    }

    public boolean visitEnter(DependencyNode node) {
        this.nodes.push(node);
        this.consumer.accept(this.lineFormatter.formatLine(this.cmp, this.nodes, this.decorators));
        return true;
    }

    public boolean visitLeave(DependencyNode node) {
        if (!this.nodes.isEmpty()) {
            this.nodes.pop();
        }
        return true;
    }
}

