/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.DependencyMapper;
import eu.maveniverse.maven.toolbox.shared.DependencyMatcher;
import eu.maveniverse.maven.toolbox.shared.Sink;
import eu.maveniverse.maven.toolbox.shared.internal.Dependencies;
import eu.maveniverse.maven.toolbox.shared.internal.SpecParser;
import eu.maveniverse.maven.toolbox.shared.internal.ToolboxCommandoImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.aether.graph.Dependency;

public final class DependencySinks {
    private DependencySinks() {
    }

    public static Dependencies.Sink build(Map<String, ?> properties, ToolboxCommandoImpl tc, boolean dryRun, String spec) {
        Objects.requireNonNull(properties, "properties");
        Objects.requireNonNull(tc, "tc");
        Objects.requireNonNull(spec, "spec");
        DependencySinkBuilder builder = new DependencySinkBuilder(properties, tc, dryRun);
        try {
            SpecParser.parse(spec).accept(builder);
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid dependency sink spec: " + spec, e);
        }
    }

    public static NullDependencySink nullDependencySink() {
        return new NullDependencySink();
    }

    public static DelegatingDependencySink delegatingDependencySink(Sink<Dependency> delegate) {
        return new DelegatingDependencySink(delegate);
    }

    public static NonClosingDependencySink nonClosingDependencySink(Sink<Dependency> delegate) {
        Objects.requireNonNull(delegate, "delegate");
        return new NonClosingDependencySink(delegate);
    }

    public static MatchingDependencySink matchingDependencySink(Predicate<Dependency> matcher, Sink<Dependency> delegate) {
        Objects.requireNonNull(matcher, "matcher");
        Objects.requireNonNull(delegate, "delegate");
        return new MatchingDependencySink(matcher, delegate);
    }

    public static MappingDependencySink mappingDependencySink(Function<Dependency, Dependency> mapper, Sink<Dependency> delegate) {
        Objects.requireNonNull(mapper, "mapper");
        Objects.requireNonNull(delegate, "delegate");
        return new MappingDependencySink(mapper, delegate);
    }

    public static CountingDependencySink countingDependencySink() {
        return new CountingDependencySink();
    }

    @SafeVarargs
    public static TeeDependencySink teeDependencySink(Sink<Dependency> ... dependencySinks) {
        return DependencySinks.teeDependencySink(Arrays.asList(dependencySinks));
    }

    public static TeeDependencySink teeDependencySink(Collection<? extends Sink<Dependency>> dependencySinks) {
        Objects.requireNonNull(dependencySinks, "dependencySinks");
        return new TeeDependencySink(dependencySinks);
    }

    static class DependencySinkBuilder
    extends SpecParser.Builder {
        private final ToolboxCommandoImpl tc;
        private final boolean dryRun;

        public DependencySinkBuilder(Map<String, ?> properties, ToolboxCommandoImpl tc, boolean dryRun) {
            super(properties);
            this.tc = tc;
            this.dryRun = dryRun;
        }

        @Override
        public boolean visitEnter(SpecParser.Node node) {
            return super.visitEnter(node) && !"matching".equals(node.getValue()) && !"mapping".equals(node.getValue());
        }

        @Override
        protected void processOp(SpecParser.Node node) {
            switch (node.getValue()) {
                case "null": {
                    this.params.add(DependencySinks.nullDependencySink());
                    break;
                }
                case "counting": {
                    this.params.add(DependencySinks.countingDependencySink());
                    break;
                }
                case "tee": {
                    this.params.add(DependencySinks.teeDependencySink(this.typedParams(Dependencies.Sink.class, node.getValue())));
                    break;
                }
                case "nonClosing": {
                    this.params.add(DependencySinks.nonClosingDependencySink(this.typedParam(Dependencies.Sink.class, node.getValue())));
                    break;
                }
                case "matching": {
                    if (node.getChildren().size() != 2) {
                        throw new IllegalArgumentException("op matching accepts only 2 argument");
                    }
                    DependencyMatcher.DependencyMatcherBuilder matcherBuilder = new DependencyMatcher.DependencyMatcherBuilder(this.properties);
                    node.getChildren().get(0).accept(matcherBuilder);
                    DependencyMatcher matcher = matcherBuilder.build();
                    DependencySinkBuilder sinkBuilder = new DependencySinkBuilder(this.properties, this.tc, this.dryRun);
                    node.getChildren().get(1).accept(sinkBuilder);
                    Dependencies.Sink delegate = sinkBuilder.build();
                    this.params.add(DependencySinks.matchingDependencySink(matcher, delegate));
                    node.getChildren().clear();
                    break;
                }
                case "mapping": {
                    if (node.getChildren().size() != 2) {
                        throw new IllegalArgumentException("op mapping accepts only 2 argument");
                    }
                    DependencyMapper.DependencyMapperBuilder mapperBuilder = new DependencyMapper.DependencyMapperBuilder(this.properties);
                    node.getChildren().get(0).accept(mapperBuilder);
                    DependencyMapper mapper = mapperBuilder.build();
                    DependencySinkBuilder sinkBuilder = new DependencySinkBuilder(this.properties, this.tc, this.dryRun);
                    node.getChildren().get(1).accept(sinkBuilder);
                    Dependencies.Sink delegate = sinkBuilder.build();
                    this.params.add(DependencySinks.mappingDependencySink(mapper, delegate));
                    node.getChildren().clear();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown op " + node.getValue());
                }
            }
        }

        public Dependencies.Sink build() {
            return this.build(Dependencies.Sink.class);
        }
    }

    public static class NullDependencySink
    implements Dependencies.Sink {
        private NullDependencySink() {
        }

        @Override
        public void accept(Collection<Dependency> dependencies) {
        }

        @Override
        public void accept(Dependency dependency) {
        }
    }

    public static class DelegatingDependencySink
    implements Dependencies.Sink {
        private final Sink<Dependency> delegate;

        private DelegatingDependencySink(Sink<Dependency> delegate) {
            Objects.requireNonNull(delegate, "delegate");
            this.delegate = delegate;
        }

        @Override
        public void accept(Dependency dependency) throws IOException {
            this.delegate.accept(dependency);
        }

        @Override
        public void cleanup(Exception e) {
            this.delegate.cleanup(e);
        }

        @Override
        public void close() throws Exception {
            this.delegate.close();
        }
    }

    public static class NonClosingDependencySink
    extends DelegatingDependencySink {
        private NonClosingDependencySink(Sink<Dependency> delegate) {
            super(delegate);
        }

        @Override
        public void close() {
        }
    }

    public static class MatchingDependencySink
    extends DelegatingDependencySink {
        private final Predicate<Dependency> matcher;

        private MatchingDependencySink(Predicate<Dependency> matcher, Sink<Dependency> delegate) {
            super(delegate);
            this.matcher = matcher;
        }

        @Override
        public void accept(Collection<Dependency> dependencies) throws IOException {
            super.accept(dependencies.stream().filter(this.matcher).collect(Collectors.toList()));
        }

        @Override
        public void accept(Dependency dependency) throws IOException {
            if (this.matcher.test(dependency)) {
                super.accept(dependency);
            }
        }
    }

    public static class MappingDependencySink
    extends DelegatingDependencySink {
        private final Function<Dependency, Dependency> mapper;

        private MappingDependencySink(Function<Dependency, Dependency> mapper, Sink<Dependency> delegate) {
            super(delegate);
            this.mapper = mapper;
        }

        @Override
        public void accept(Collection<Dependency> dependencies) throws IOException {
            super.accept(dependencies.stream().map(this.mapper).collect(Collectors.toList()));
        }

        @Override
        public void accept(Dependency dependency) throws IOException {
            super.accept(this.mapper.apply(dependency));
        }
    }

    public static class CountingDependencySink
    implements Dependencies.Sink {
        private final LongAdder counter = new LongAdder();

        private CountingDependencySink() {
        }

        @Override
        public void accept(Dependency dependency) {
            this.counter.increment();
        }

        public int count() {
            return this.counter.intValue();
        }
    }

    public static class TeeDependencySink
    implements Dependencies.Sink {
        private final Collection<Sink<Dependency>> dependencySinks;

        private TeeDependencySink(Collection<? extends Sink<Dependency>> artifactSinks) {
            this.dependencySinks = Collections.unmodifiableCollection(new ArrayList<Sink<Dependency>>(artifactSinks));
        }

        @Override
        public void accept(Collection<Dependency> dependencies) throws IOException {
            for (Sink<Dependency> sink : this.dependencySinks) {
                sink.accept(dependencies);
            }
        }

        @Override
        public void accept(Dependency dependency) throws IOException {
            for (Sink<Dependency> sink : this.dependencySinks) {
                sink.accept(dependency);
            }
        }

        @Override
        public void cleanup(Exception e) {
            for (Sink<Dependency> sink : this.dependencySinks) {
                sink.cleanup(e);
            }
        }

        @Override
        public void close() throws Exception {
            for (Sink<Dependency> sink : this.dependencySinks) {
                sink.close();
            }
        }
    }
}

