/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.domtrip.Document;
import eu.maveniverse.maven.toolbox.shared.ArtifactMapper;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.FileUtils;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.internal.ExtensionsSuppliers;
import eu.maveniverse.maven.toolbox.shared.internal.domtrip.SmartExtensionsEditor;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.aether.artifact.Artifact;
import org.maveniverse.domtrip.maven.ExtensionsEditor;

public final class ExtensionsTransformerSink
implements Artifacts.Sink {
    private final Output output;
    private final Path extensions;
    private final Supplier<String> extensionsSupplier;
    private final Predicate<Artifact> artifactMatcher;
    private final Function<Artifact, Artifact> artifactMapper;
    private final Function<Artifact, Consumer<SmartExtensionsEditor>> transformation;
    private final ArrayList<Consumer<SmartExtensionsEditor>> applicableTransformations;

    public static ExtensionsTransformerSink transform(Output output, Path extensions, ToolboxCommando.Op op) {
        return ExtensionsTransformerSink.transform(output, extensions, ExtensionsSuppliers::empty120, ArtifactMatcher.any(), ArtifactMapper.identity(), op);
    }

    public static ExtensionsTransformerSink transform(Output output, Path extensions, Supplier<String> extensionsSupplier, Predicate<Artifact> artifactMatcher, Function<Artifact, Artifact> artifactMapper, ToolboxCommando.Op op) {
        return new ExtensionsTransformerSink(output, extensions, extensionsSupplier, artifactMatcher, artifactMapper, op);
    }

    private ExtensionsTransformerSink(Output output, Path extensions, Supplier<String> extensionsSupplier, Predicate<Artifact> artifactMatcher, Function<Artifact, Artifact> artifactMapper, ToolboxCommando.Op op) {
        this.output = Objects.requireNonNull(output, "output");
        this.extensions = Objects.requireNonNull(extensions, "extensions").toAbsolutePath();
        this.extensionsSupplier = Objects.requireNonNull(extensionsSupplier, "extensionsSupplier");
        this.artifactMatcher = Objects.requireNonNull(artifactMatcher, "artifactMatcher");
        this.artifactMapper = Objects.requireNonNull(artifactMapper, "artifactMapper");
        Objects.requireNonNull(op, "op");
        this.transformation = switch (op) {
            default -> throw new IncompatibleClassChangeError();
            case ToolboxCommando.Op.UPSERT, ToolboxCommando.Op.UPDATE -> a -> e -> e.updateExtension(op == ToolboxCommando.Op.UPSERT, (Artifact)a);
            case ToolboxCommando.Op.DELETE -> a -> e -> e.deleteExtension((Artifact)a);
        };
        this.applicableTransformations = new ArrayList();
    }

    public Path getExtensionsPath() {
        return this.extensions;
    }

    @Override
    public void accept(Artifact artifact) throws IOException {
        Consumer<SmartExtensionsEditor> transformation;
        Objects.requireNonNull(artifact, "artifact");
        if (this.artifactMatcher.test(artifact) && (transformation = this.transformation.apply(this.artifactMapper.apply(artifact))) != null) {
            this.output.chatter("Accepted {}", artifact);
            this.applicableTransformations.add(transformation);
        }
    }

    @Override
    public void cleanup(Exception e) {
        try {
            Files.deleteIfExists(this.extensions);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        Document document;
        if (!Files.isRegularFile(this.extensions, new LinkOption[0])) {
            Files.createDirectories(this.extensions.getParent(), new FileAttribute[0]);
            document = Document.of((String)this.extensionsSupplier.get());
        } else {
            document = Document.of((Path)this.extensions);
        }
        SmartExtensionsEditor editor = new SmartExtensionsEditor(new ExtensionsEditor(document));
        try (FileUtils.CollocatedTempFile tempFile = FileUtils.newTempFile(this.extensions, false);){
            for (Consumer<SmartExtensionsEditor> transformation : this.applicableTransformations) {
                transformation.accept(editor);
            }
            Files.writeString(tempFile.getPath(), (CharSequence)document.toXml(), new OpenOption[0]);
            tempFile.move();
        }
    }
}

