/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public final class IndexFileReader
implements AutoCloseable {
    private final Path indexFile;

    public IndexFileReader(Path indexFile) {
        this.indexFile = Objects.requireNonNull(indexFile, "indexFile").toAbsolutePath();
    }

    public Stream<Artifact> read(Function<String, Path> pathResolver) throws IOException {
        return Files.readAllLines(this.indexFile).stream().filter(l -> !l.trim().isEmpty() && !l.startsWith("#")).map(l -> {
            String[] parts = l.split(" >> ", -1);
            return new DefaultArtifact(parts[0]).setFile(((Path)pathResolver.apply(parts[1])).toFile());
        });
    }

    @Override
    public void close() {
    }
}

