/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.util.graph.selector.StaticDependencySelector;

public class LevelDependencySelector
implements DependencySelector {
    private final int maxLevel;
    private final int currentLevel;

    public LevelDependencySelector(int maxLevel) {
        if (maxLevel < 1) {
            throw new IllegalArgumentException("maxLevel must be greater than 0");
        }
        this.maxLevel = maxLevel;
        this.currentLevel = 0;
    }

    private LevelDependencySelector(int maxLevel, int currentLevel) {
        this.maxLevel = maxLevel;
        this.currentLevel = currentLevel;
    }

    public boolean selectDependency(Dependency dependency) {
        return true;
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        int newLevel = this.currentLevel + 1;
        if (newLevel > this.maxLevel) {
            return new StaticDependencySelector(false);
        }
        return new LevelDependencySelector(this.maxLevel, newLevel);
    }
}

