/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.IOException;
import java.lang.module.FindException;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;

public final class ModuleDescriptorExtractingSink
implements Artifacts.Sink,
DependencyVisitor {
    private final Output output;
    private final ConcurrentMap<Artifact, ModuleDescriptor> moduleDescriptors;
    private static final ModuleDescriptor NOT_AVAILABLE = new ModuleDescriptor(){

        @Override
        public boolean available() {
            return false;
        }

        @Override
        public String name() {
            return "";
        }

        @Override
        public boolean automatic() {
            return false;
        }

        @Override
        public String moduleNameSource() {
            return "";
        }
    };

    public ModuleDescriptorExtractingSink(Output output) {
        this.output = Objects.requireNonNull(output, "output");
        this.moduleDescriptors = new ConcurrentHashMap<Artifact, ModuleDescriptor>();
    }

    @Override
    public void accept(Artifact artifact) throws IOException {
        if (artifact.getFile() != null) {
            this.moduleDescriptors.computeIfAbsent(artifact, k -> this.getModuleDescriptor(artifact.getFile().toPath()));
        }
    }

    public String formatString(ModuleDescriptor moduleDescriptor) {
        Object moduleInfo;
        if (moduleDescriptor == null || !moduleDescriptor.available()) {
            moduleInfo = "n/a";
        } else {
            moduleInfo = "JPMS: " + moduleDescriptor.name();
            if (moduleDescriptor.automatic()) {
                moduleInfo = "MANIFEST".equals(moduleDescriptor.moduleNameSource()) ? (String)moduleInfo + " [automatic; JAR manifest]" : (String)moduleInfo + " (automatic: JAR filename)";
            }
        }
        return moduleInfo;
    }

    public ModuleDescriptor getModuleDescriptor(Artifact artifact) {
        return (ModuleDescriptor)this.moduleDescriptors.get(artifact);
    }

    public Map<Artifact, ModuleDescriptor> getModuleDescriptors() {
        return Collections.unmodifiableMap(this.moduleDescriptors);
    }

    private ModuleDescriptor getModuleDescriptor(Path artifactPath) {
        ModuleDescriptor moduleDescriptor;
        block11: {
            moduleDescriptor = NOT_AVAILABLE;
            try {
                ModuleFinder moduleFinder = ModuleFinder.of(artifactPath);
                Set<ModuleReference> moduleReferences = moduleFinder.findAll();
                if (moduleReferences.isEmpty()) break block11;
                ModuleReference moduleReference = moduleReferences.iterator().next();
                java.lang.module.ModuleDescriptor moduleDescriptorInstance = moduleReference.descriptor();
                String moduleNameSource = "";
                if (moduleDescriptorInstance.isAutomatic() && Files.isRegularFile(artifactPath, new LinkOption[0])) {
                    try (JarFile jarFile = new JarFile(artifactPath.toFile());){
                        Manifest manifest = jarFile.getManifest();
                        moduleNameSource = manifest != null && manifest.getMainAttributes().getValue("Automatic-Module-Name") != null ? "MANIFEST" : "FILENAME";
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                moduleDescriptor = new ModuleDescriptorImpl(moduleDescriptorInstance.name(), moduleDescriptorInstance.isAutomatic(), moduleNameSource);
            }
            catch (IllegalArgumentException | SecurityException e) {
                this.output.warn("Ignored Exception:", e);
            }
            catch (FindException e) {
                this.output.warn("Can't extract module name from {}:", artifactPath.getFileName(), e);
            }
        }
        return moduleDescriptor;
    }

    public boolean visitEnter(DependencyNode dependencyNode) {
        if (dependencyNode.getDependency() != null) {
            try {
                this.accept(dependencyNode.getDependency().getArtifact());
            }
            catch (IOException e) {
                this.output.warn("IO problem: ", e);
            }
        }
        return true;
    }

    public boolean visitLeave(DependencyNode dependencyNode) {
        return true;
    }

    public Function<DependencyNode, String> decorator() {
        return node -> {
            ModuleDescriptor moduleDescriptor;
            if (node != null && node.getDependency() != null && (moduleDescriptor = this.getModuleDescriptor(node.getDependency().getArtifact())) != null) {
                return this.formatString(moduleDescriptor);
            }
            return null;
        };
    }

    public static interface ModuleDescriptor {
        public boolean available();

        public String name();

        public boolean automatic();

        public String moduleNameSource();
    }

    private static class ModuleDescriptorImpl
    implements ModuleDescriptor {
        private final String name;
        private final boolean automatic;
        private final String moduleNameSource;

        private ModuleDescriptorImpl(String name, boolean automatic, String moduleNameSource) {
            this.name = name;
            this.automatic = automatic;
            this.moduleNameSource = moduleNameSource;
        }

        @Override
        public boolean available() {
            return true;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean automatic() {
            return this.automatic;
        }

        @Override
        public String moduleNameSource() {
            return this.moduleNameSource;
        }
    }
}

