/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.domtrip.Document;
import eu.maveniverse.maven.toolbox.shared.ArtifactMapper;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.FileUtils;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.internal.PomSuppliers;
import eu.maveniverse.maven.toolbox.shared.internal.domtrip.SmartPomEditor;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.aether.artifact.Artifact;
import org.maveniverse.domtrip.maven.PomEditor;

public final class PomTransformerSink
implements Artifacts.Sink {
    private final Output output;
    private final Path pom;
    private final Supplier<String> pomSupplier;
    private final Predicate<Artifact> artifactMatcher;
    private final Function<Artifact, Artifact> artifactMapper;
    private final Function<Artifact, Consumer<SmartPomEditor>> transformation;
    private final ArrayList<Consumer<SmartPomEditor>> applicableTransformations;

    public static PomTransformerSink transform(Output output, Path pom, ToolboxCommando.PomOpSubject subject, ToolboxCommando.Op op) {
        return PomTransformerSink.transform(output, pom, () -> PomSuppliers.empty400("org.acme", "acme", "1.0.0-SNAPSHOT"), ArtifactMatcher.any(), ArtifactMapper.identity(), subject, op);
    }

    public static PomTransformerSink transform(Output output, Path pom, Supplier<String> pomSupplier, Predicate<Artifact> artifactMatcher, Function<Artifact, Artifact> artifactMapper, ToolboxCommando.PomOpSubject subject, ToolboxCommando.Op op) {
        return new PomTransformerSink(output, pom, pomSupplier, artifactMatcher, artifactMapper, subject, op);
    }

    private PomTransformerSink(Output output, Path pom, Supplier<String> pomSupplier, Predicate<Artifact> artifactMatcher, Function<Artifact, Artifact> artifactMapper, ToolboxCommando.PomOpSubject subject, ToolboxCommando.Op op) {
        this.output = Objects.requireNonNull(output, "output");
        this.pom = Objects.requireNonNull(pom, "pom").toAbsolutePath();
        this.pomSupplier = Objects.requireNonNull(pomSupplier, "pomSupplier");
        this.artifactMatcher = Objects.requireNonNull(artifactMatcher, "artifactMatcher");
        this.artifactMapper = Objects.requireNonNull(artifactMapper, "artifactMapper");
        Objects.requireNonNull(subject, "subject");
        Objects.requireNonNull(op, "op");
        this.transformation = switch (op) {
            default -> throw new IncompatibleClassChangeError();
            case ToolboxCommando.Op.UPSERT, ToolboxCommando.Op.UPDATE -> {
                switch (subject) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case MANAGED_PLUGINS: {
                        yield a -> e -> e.updateManagedPlugin(op == ToolboxCommando.Op.UPSERT, (Artifact)a);
                    }
                    case PLUGINS: {
                        yield a -> e -> e.updatePlugin(op == ToolboxCommando.Op.UPSERT, (Artifact)a);
                    }
                    case MANAGED_DEPENDENCIES: {
                        yield a -> e -> e.updateManagedDependency(op == ToolboxCommando.Op.UPSERT, (Artifact)a);
                    }
                    case DEPENDENCIES: {
                        yield a -> e -> e.updateDependency(op == ToolboxCommando.Op.UPSERT, (Artifact)a);
                    }
                    case EXTENSIONS: 
                }
                yield a -> e -> e.updateExtension(op == ToolboxCommando.Op.UPSERT, (Artifact)a);
            }
            case ToolboxCommando.Op.DELETE -> {
                switch (subject) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case MANAGED_PLUGINS: {
                        yield a -> e -> e.deleteManagedPlugin((Artifact)a);
                    }
                    case PLUGINS: {
                        yield a -> e -> e.deletePlugin((Artifact)a);
                    }
                    case MANAGED_DEPENDENCIES: {
                        yield a -> e -> e.deleteManagedDependency((Artifact)a);
                    }
                    case DEPENDENCIES: {
                        yield a -> e -> e.deleteDependency((Artifact)a);
                    }
                    case EXTENSIONS: 
                }
                yield a -> e -> e.deleteExtension((Artifact)a);
            }
        };
        this.applicableTransformations = new ArrayList();
    }

    public Path getPomPath() {
        return this.pom;
    }

    @Override
    public void accept(Artifact artifact) throws IOException {
        Consumer<SmartPomEditor> transformation;
        Objects.requireNonNull(artifact, "artifact");
        if (this.artifactMatcher.test(artifact) && (transformation = this.transformation.apply(this.artifactMapper.apply(artifact))) != null) {
            this.output.chatter("Accepted {}", artifact);
            this.applicableTransformations.add(transformation);
        }
    }

    @Override
    public void cleanup(Exception e) {
        try {
            Files.deleteIfExists(this.pom);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        Document document;
        if (!Files.isRegularFile(this.pom, new LinkOption[0])) {
            Files.createDirectories(this.pom.getParent(), new FileAttribute[0]);
            document = Document.of((String)this.pomSupplier.get());
        } else {
            document = Document.of((Path)this.pom);
        }
        SmartPomEditor editor = new SmartPomEditor(new PomEditor(document));
        try (FileUtils.CollocatedTempFile tempFile = FileUtils.newTempFile(this.pom, false);){
            for (Consumer<SmartPomEditor> transformation : this.applicableTransformations) {
                transformation.accept(editor);
            }
            Files.writeString(tempFile.getPath(), (CharSequence)document.toXml(), new OpenOption[0]);
            tempFile.move();
        }
    }
}

