/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactNameMapper;
import eu.maveniverse.maven.toolbox.shared.internal.Artifacts;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;

public final class PurgingSink
implements Artifacts.Sink {
    private final Output output;
    private final Mode mode;
    private final boolean enforceOrigin;
    private final AtomicBoolean perform;
    private final RepositorySystem system;
    private final RepositorySystemSession session;
    private final List<RemoteRepository> remoteRepositories;
    private final boolean dryRun;
    private final ArrayList<Artifact> artifacts;
    private final Predicate<Artifact> artifactMatcher;
    private final AtomicInteger purgedArtifacts;

    public static PurgingSink purging(Output output, RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> remoteRepositories, boolean dryRun) {
        return PurgingSink.purging(output, Mode.WHOLE, false, system, session, remoteRepositories, dryRun);
    }

    public static PurgingSink purging(Output output, Mode mode, boolean enforceOrigin, RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> remoteRepositories, boolean dryRun) {
        return new PurgingSink(output, mode, enforceOrigin, system, session, remoteRepositories, dryRun);
    }

    private PurgingSink(Output output, Mode mode, boolean enforceOrigin, RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> remoteRepositories, boolean dryRun) {
        this.output = Objects.requireNonNull(output, "output");
        this.mode = Objects.requireNonNull(mode, "mode");
        this.enforceOrigin = enforceOrigin;
        this.perform = new AtomicBoolean(true);
        this.system = Objects.requireNonNull(system, "system");
        this.session = Objects.requireNonNull(session, "session");
        this.remoteRepositories = Objects.requireNonNull(remoteRepositories, "remoteRepositories");
        this.dryRun = dryRun;
        this.artifacts = new ArrayList();
        this.purgedArtifacts = new AtomicInteger(-1);
        switch (mode.ordinal()) {
            case 0: {
                this.artifactMatcher = ArtifactMatcher.unique();
                break;
            }
            case 1: {
                this.artifactMatcher = ArtifactMatcher.uniqueBy(ArtifactNameMapper.GAVKey());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown mode");
            }
        }
    }

    public LocalRepository getLocalRepository() {
        return this.session.getLocalRepository();
    }

    @Override
    public void accept(Artifact artifact) {
        Objects.requireNonNull(artifact, "artifact");
        if (this.artifactMatcher.test(artifact)) {
            Objects.requireNonNull(artifact.getFile(), "unresolved artifact");
            if (this.enforceOrigin && !artifact.getFile().toPath().startsWith(this.session.getLocalRepository().getBasedir().toPath())) {
                throw new IllegalArgumentException("artifact does not originate from local repository to be purged");
            }
            this.output.chatter("Accepted artifact {}", artifact);
            this.artifacts.add(artifact);
        }
    }

    @Override
    public void cleanup(Exception e) {
        this.perform.set(false);
    }

    @Override
    public void close() throws IOException {
        if (this.perform.get()) {
            this.output.suggest("Performing purge", new Object[0]);
            int artifactCount = 0;
            for (Artifact artifact : this.artifacts) {
                boolean purged = this.purgeArtifact(artifact);
                this.output.chatter("Purge of {}: {}", artifact, purged ? "DONE" : "NOT DONE");
                artifactCount += purged ? 1 : 0;
            }
            this.purgedArtifacts.set(artifactCount);
        }
    }

    public int getPurgedArtifactsCount() {
        return this.purgedArtifacts.get();
    }

    private boolean purgeArtifact(Artifact artifact) throws IOException {
        switch (this.mode.ordinal()) {
            case 0: {
                return this.purgeExact(artifact);
            }
            case 1: {
                return this.purgeGAV(artifact);
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean purgeExact(Artifact artifact) throws IOException {
        if (this.dryRun) {
            return true;
        }
        int deleted = 0;
        Path path = this.session.getLocalRepository().getBasedir().toPath().resolve(this.session.getLocalRepositoryManager().getPathForLocalArtifact(artifact));
        if (Files.isDirectory(path.getParent(), new LinkOption[0])) {
            this.unregisterArtifact(path);
            this.resetMetadata(path.getParent(), artifact.isSnapshot() && Objects.equals(artifact.getVersion(), artifact.getBaseVersion()));
            deleted = this.deleteFileAndSubs(this.session.getLocalRepository().getBasedir().toPath().resolve(this.session.getLocalRepositoryManager().getPathForLocalArtifact(artifact)));
        }
        for (RemoteRepository repository : this.remoteRepositories) {
            path = this.session.getLocalRepository().getBasedir().toPath().resolve(this.session.getLocalRepositoryManager().getPathForRemoteArtifact(artifact, repository, null));
            if (!Files.isDirectory(path.getParent(), new LinkOption[0])) continue;
            this.unregisterArtifact(path);
            this.resetMetadata(path.getParent(), artifact.isSnapshot() && Objects.equals(artifact.getVersion(), artifact.getBaseVersion()));
            deleted += this.deleteFileAndSubs(this.session.getLocalRepository().getBasedir().toPath().resolve(this.session.getLocalRepositoryManager().getPathForLocalArtifact(artifact)));
        }
        return deleted != 0;
    }

    private boolean purgeGAV(Artifact artifact) throws IOException {
        if (this.dryRun) {
            return true;
        }
        return this.deleteDirectory(this.session.getLocalRepository().getBasedir().toPath().resolve(this.session.getLocalRepositoryManager().getPathForLocalArtifact(artifact)).getParent()) != 0;
    }

    private void unregisterArtifact(Path artifactPath) throws IOException {
        Path registrarPath = artifactPath.getParent().resolve("_remote.repositories");
        if (Files.isRegularFile(registrarPath, new LinkOption[0])) {
            String keyPrefix = artifactPath.getFileName().toString() + ">";
            Properties registrar = new Properties();
            try (InputStream input = Files.newInputStream(registrarPath, new OpenOption[0]);){
                registrar.load(input);
            }
            for (String key : new HashSet<String>(registrar.stringPropertyNames())) {
                if (!key.startsWith(keyPrefix)) continue;
                registrar.remove(key);
            }
            try (OutputStream output = Files.newOutputStream(registrarPath, new OpenOption[0]);){
                registrar.store(output, "#NOTE: This is a Maven Resolver internal implementation file, its format can be changed without prior notice.");
            }
        }
    }

    private void resetMetadata(Path directory, boolean local) throws IOException {
        try (DirectoryStream<Path> toBeDeleted = Files.newDirectoryStream(directory, p -> Files.exists(p, new LinkOption[0]) && !Files.isDirectory(p, new LinkOption[0]) && p.getFileName().startsWith("maven-metadata-") && p.getFileName().endsWith(".xml"));){
            for (Path p2 : toBeDeleted) {
                if (!local && "maven-metadata-local.xml".equals(p2.getFileName().toString())) continue;
                Files.delete(p2);
            }
        }
        Files.deleteIfExists(directory.resolve("resolver-status.properties"));
    }

    private int deleteFileAndSubs(Path path) throws IOException {
        int deleted = 0;
        if (Files.isDirectory(path.getParent(), new LinkOption[0])) {
            try (DirectoryStream<Path> toBeDeleted = Files.newDirectoryStream(path.getParent(), p -> Files.exists(p, new LinkOption[0]) && !Files.isDirectory(p, new LinkOption[0]) && p.startsWith(path));){
                for (Path p2 : toBeDeleted) {
                    Files.delete(p2);
                    ++deleted;
                }
            }
        }
        return deleted;
    }

    private int deleteDirectory(Path directory) throws IOException {
        int found = 0;
        int deleted = 0;
        if (Files.isDirectory(directory, new LinkOption[0])) {
            try (DirectoryStream<Path> toBeDeleted = Files.newDirectoryStream(directory);){
                for (Path p : toBeDeleted) {
                    ++found;
                    if (Files.isDirectory(p, new LinkOption[0])) continue;
                    Files.delete(p);
                    ++deleted;
                }
            }
            if (found == deleted) {
                Files.delete(directory);
            }
        }
        return deleted;
    }

    public static enum Mode {
        EXACT,
        WHOLE;

    }
}

