/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal;

import eu.maveniverse.domtrip.Document;
import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.HTTPProxy;
import eu.maveniverse.maven.mima.context.MavenSystemHome;
import eu.maveniverse.maven.mima.context.MavenUserHome;
import eu.maveniverse.maven.mima.context.Runtime;
import eu.maveniverse.maven.mima.context.internal.RuntimeSupport;
import eu.maveniverse.maven.mima.extensions.mmr.MavenModelReader;
import eu.maveniverse.maven.mima.extensions.mmr.ModelResponse;
import eu.maveniverse.maven.toolbox.shared.ArtifactDifferentiator;
import eu.maveniverse.maven.toolbox.shared.ArtifactKeyFactory;
import eu.maveniverse.maven.toolbox.shared.ArtifactMapper;
import eu.maveniverse.maven.toolbox.shared.ArtifactMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactNameMapper;
import eu.maveniverse.maven.toolbox.shared.ArtifactRecorder;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionMatcher;
import eu.maveniverse.maven.toolbox.shared.ArtifactVersionSelector;
import eu.maveniverse.maven.toolbox.shared.DependencyMatcher;
import eu.maveniverse.maven.toolbox.shared.FileUtils;
import eu.maveniverse.maven.toolbox.shared.ReactorLocator;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.Sink;
import eu.maveniverse.maven.toolbox.shared.Source;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.ToolboxResolver;
import eu.maveniverse.maven.toolbox.shared.ToolboxSearchApi;
import eu.maveniverse.maven.toolbox.shared.internal.ArtifactConflictComparator;
import eu.maveniverse.maven.toolbox.shared.internal.ArtifactListComparator;
import eu.maveniverse.maven.toolbox.shared.internal.ArtifactRecorderImpl;
import eu.maveniverse.maven.toolbox.shared.internal.ArtifactSinks;
import eu.maveniverse.maven.toolbox.shared.internal.ArtifactSources;
import eu.maveniverse.maven.toolbox.shared.internal.DependencyGraphComparator;
import eu.maveniverse.maven.toolbox.shared.internal.DependencyGraphDecorators;
import eu.maveniverse.maven.toolbox.shared.internal.DependencyGraphDumper;
import eu.maveniverse.maven.toolbox.shared.internal.DependencySinks;
import eu.maveniverse.maven.toolbox.shared.internal.ExtensionsTransformerSink;
import eu.maveniverse.maven.toolbox.shared.internal.LibYearSink;
import eu.maveniverse.maven.toolbox.shared.internal.PomSuppliers;
import eu.maveniverse.maven.toolbox.shared.internal.PomTransformerSink;
import eu.maveniverse.maven.toolbox.shared.internal.ToolboxGraphImpl;
import eu.maveniverse.maven.toolbox.shared.internal.ToolboxResolverImpl;
import eu.maveniverse.maven.toolbox.shared.internal.ToolboxSearchApiImpl;
import eu.maveniverse.maven.toolbox.shared.internal.domtrip.SmartExtensionsEditor;
import eu.maveniverse.maven.toolbox.shared.internal.domtrip.SmartPomEditor;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.StringCharacterIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.io.xpp3.MavenXpp3WriterEx;
import org.apache.maven.search.api.MAVEN;
import org.apache.maven.search.api.SearchBackend;
import org.apache.maven.search.api.SearchRequest;
import org.apache.maven.search.api.SearchResponse;
import org.apache.maven.search.api.request.BooleanQuery;
import org.apache.maven.search.api.request.Field;
import org.apache.maven.search.api.request.FieldQuery;
import org.apache.maven.search.api.request.Query;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.util.ChecksumUtils;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.util.graph.visitor.CloningDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.util.listener.ChainedRepositoryListener;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionScheme;
import org.maveniverse.domtrip.maven.ExtensionsEditor;
import org.maveniverse.domtrip.maven.PomEditor;

public class ToolboxCommandoImpl
implements ToolboxCommando {
    protected final Output output;
    protected final Context context;
    protected final RepositorySystemSession session;
    protected final VersionScheme versionScheme;
    protected final ToolboxSearchApiImpl toolboxSearchApi;
    protected final ArtifactRecorderImpl artifactRecorder;
    protected final ToolboxResolverImpl toolboxResolver;
    protected final ToolboxGraphImpl toolboxGraph;
    protected final Map<String, RemoteRepository> knownSearchRemoteRepositories;

    public ToolboxCommandoImpl(Output output, Context context) {
        this.output = Objects.requireNonNull(output, "output");
        this.context = Objects.requireNonNull(context, "context");
        this.versionScheme = new GenericVersionScheme();
        this.toolboxSearchApi = new ToolboxSearchApiImpl(output);
        this.artifactRecorder = new ArtifactRecorderImpl();
        DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(context.repositorySystemSession());
        session.setRepositoryListener(ChainedRepositoryListener.newInstance((RepositoryListener)session.getRepositoryListener(), (RepositoryListener)this.artifactRecorder));
        this.session = session;
        this.toolboxResolver = new ToolboxResolverImpl(output, context.repositorySystem(), (RepositorySystemSession)session, new MavenModelReader(context), context.remoteRepositories(), this.versionScheme);
        this.toolboxGraph = new ToolboxGraphImpl(output);
        this.knownSearchRemoteRepositories = Collections.unmodifiableMap(this.createKnownSearchRemoteRepositories());
    }

    public Path basedir() {
        return this.context.basedir();
    }

    public Output output() {
        return this.output;
    }

    public RepositorySystem repositorySystem() {
        return this.context.repositorySystem();
    }

    public RepositorySystemSession session() {
        return this.session;
    }

    public List<RemoteRepository> remoteRepositories() {
        return this.context.remoteRepositories();
    }

    public ArtifactRecorder recorder() {
        return this.artifactRecorder;
    }

    protected Map<String, RemoteRepository> createKnownSearchRemoteRepositories() {
        HashMap<String, RemoteRepository> rr = new HashMap<String, RemoteRepository>();
        rr.put(ContextOverrides.CENTRAL.getId(), this.parseRemoteRepository(ContextOverrides.CENTRAL.getId() + "::central::" + ContextOverrides.CENTRAL.getUrl()));
        rr.put("sonatype-oss-releases", this.parseRemoteRepository("sonatype-oss-releases::nx2::https://oss.sonatype.org/content/repositories/releases/"));
        rr.put("sonatype-oss-staging", this.parseRemoteRepository("sonatype-oss-staging::nx2::https://oss.sonatype.org/content/groups/staging/"));
        rr.put("sonatype-s01-releases", this.parseRemoteRepository("sonatype-s01-releases::nx2::https://s01.oss.sonatype.org/content/repositories/releases/"));
        rr.put("sonatype-s01-staging", this.parseRemoteRepository("sonatype-s01-staging::nx2::https://s01.oss.sonatype.org/content/groups/staging/"));
        rr.put("apache-releases", this.parseRemoteRepository("apache-releases::nx2::https://repository.apache.org/content/repositories/releases/"));
        rr.put("apache-staging", this.parseRemoteRepository("apache-staging::nx2::https://repository.apache.org/content/groups/staging/"));
        rr.put("apache-maven-staging", this.parseRemoteRepository("apache-maven-staging::nx2::https://repository.apache.org/content/groups/maven-staging-group/"));
        return rr;
    }

    @Override
    public ToolboxCommando withContextOverrides(ContextOverrides overrides) {
        return new ToolboxCommandoImpl(this.output, this.context.customize(overrides));
    }

    @Override
    public void close() {
        this.context.close();
    }

    @Override
    public Result<String> dump() {
        Runtime runtime = this.context.getRuntime();
        this.output.marker(Output.Verbosity.TIGHT).emphasize("Toolbox {}").normal(" (MIMA Runtime '{}' version {})").say(this.getVersion(), runtime.name(), runtime.version());
        this.output.doTell("", new Object[0]);
        this.output.tell("          Maven version {}", runtime.mavenVersion());
        this.output.tell("                Managed {}", runtime.managedRepositorySystem());
        this.output.tell("                Basedir {}", this.context.basedir());
        this.output.tell("                Offline {}", this.context.repositorySystemSession().isOffline());
        MavenSystemHome mavenSystemHome = this.context.mavenSystemHome();
        this.output.tell("", new Object[0]);
        this.output.tell("             MAVEN_HOME {}", mavenSystemHome == null ? "undefined" : mavenSystemHome.basedir());
        if (mavenSystemHome != null) {
            this.output.tell("           settings.xml {}", mavenSystemHome.settingsXml());
            this.output.tell("         toolchains.xml {}", mavenSystemHome.toolchainsXml());
        }
        MavenUserHome mavenUserHome = this.context.mavenUserHome();
        this.output.tell("", new Object[0]);
        this.output.tell("              USER_HOME {}", mavenUserHome.basedir());
        this.output.tell("           settings.xml {}", mavenUserHome.settingsXml());
        this.output.tell("  settings-security.xml {}", mavenUserHome.settingsSecurityXml());
        this.output.tell("       local repository {}", mavenUserHome.localRepository());
        this.output.tell("", new Object[0]);
        this.output.tell("               PROFILES", new Object[0]);
        this.output.tell("                 Active {}", this.context.contextOverrides().getActiveProfileIds());
        this.output.tell("               Inactive {}", this.context.contextOverrides().getInactiveProfileIds());
        this.output.tell("", new Object[0]);
        this.output.tell("    REMOTE REPOSITORIES", new Object[0]);
        for (RemoteRepository repository : this.context.remoteRepositories()) {
            if (repository.getMirroredRepositories().isEmpty()) {
                this.output.tell("                        {}", repository);
                continue;
            }
            this.output.tell("                        {}, mirror of", repository);
            for (RemoteRepository mirrored : repository.getMirroredRepositories()) {
                this.output.tell("                          {}", mirrored);
            }
        }
        if (this.context.httpProxy() != null) {
            HTTPProxy proxy = this.context.httpProxy();
            this.output.tell("", new Object[0]);
            this.output.tell("             HTTP PROXY", new Object[0]);
            this.output.tell("                    url {}://{}:{}", proxy.getProtocol(), proxy.getHost(), proxy.getPort());
            this.output.tell("          nonProxyHosts {}", proxy.getNonProxyHosts());
        }
        if (this.output.isHeard(Output.Verbosity.SUGGEST)) {
            this.output.suggest("", new Object[0]);
            this.output.suggest("        USER PROPERTIES", new Object[0]);
            this.context.repositorySystemSession().getUserProperties().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> this.output.suggest("                         {}={}", e.getKey(), e.getValue()));
            this.output.suggest("      SYSTEM PROPERTIES", new Object[0]);
            this.context.repositorySystemSession().getSystemProperties().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> this.output.suggest("                         {}={}", e.getKey(), e.getValue()));
            this.output.suggest("      CONFIG PROPERTIES", new Object[0]);
            this.context.repositorySystemSession().getConfigProperties().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> this.output.suggest("                         {}={}", e.getKey(), e.getValue()));
            this.output.suggest("", new Object[0]);
            if (this.output.isHeard(Output.Verbosity.CHATTER)) {
                this.output.tell("OUTPUT TEST:", new Object[0]);
                this.output.chatter("Chatter: {}", "Message", new RuntimeException("runtime"));
                this.output.suggest("Suggest: {}", "Message", new RuntimeException("runtime"));
                this.output.tell("Tell: {}", "Message", new RuntimeException("runtime"));
                this.output.doTell("Do Tell: {}", "Message", new RuntimeException("runtime"));
            }
        }
        return Result.success("Success");
    }

    @Override
    public Result<Map<String, String>> dumpAsMap() {
        HashMap<Object, String> result = new HashMap<Object, String>();
        result.put("toolbox.version", this.getVersion());
        Runtime runtime = this.context.getRuntime();
        result.put("mima.runtime.name", runtime.name());
        result.put("mima.runtime.version", runtime.version());
        result.put("maven.version", runtime.mavenVersion());
        result.put("maven.managed", String.valueOf(runtime.managedRepositorySystem()));
        if (this.context.mavenSystemHome() != null) {
            result.put("maven.home", String.valueOf(this.context.mavenSystemHome().basedir()));
            result.put("maven.settings", String.valueOf(this.context.mavenSystemHome().settingsXml()));
            result.put("maven.toolchains", String.valueOf(this.context.mavenSystemHome().toolchainsXml()));
        }
        result.put("user.home", String.valueOf(this.context.mavenUserHome().basedir()));
        result.put("user.settings", String.valueOf(this.context.mavenUserHome().settingsXml()));
        result.put("user.toolchains", String.valueOf(this.context.mavenUserHome().toolchainsXml()));
        result.put("user.settingsSecurity", String.valueOf(this.context.mavenUserHome().settingsSecurityXml()));
        result.put("user.repository", String.valueOf(this.context.mavenUserHome().localRepository()));
        result.put("profiles.active", String.join((CharSequence)",", this.context.contextOverrides().getActiveProfileIds()));
        result.put("profiles.inactive", String.join((CharSequence)",", this.context.contextOverrides().getInactiveProfileIds()));
        result.put("basedir", String.valueOf(this.context.basedir()));
        result.put("session.offline", String.valueOf(this.context.repositorySystemSession().isOffline()));
        int counter = 1;
        for (RemoteRepository repository : this.context.remoteRepositories()) {
            String repoPrefix = "repository." + counter++ + ".";
            result.put(repoPrefix + "id", repository.getId());
            result.put(repoPrefix + "url", repository.getUrl());
            result.put(repoPrefix + "contentType", repository.getContentType());
            result.put(repoPrefix + "release", String.valueOf(repository.getPolicy(false).isEnabled()));
            result.put(repoPrefix + "snapshot", String.valueOf(repository.getPolicy(true).isEnabled()));
            if (repository.getMirroredRepositories().isEmpty()) continue;
            repoPrefix = repoPrefix + "mirroring.";
            for (RemoteRepository mirrored : repository.getMirroredRepositories()) {
                result.put(repoPrefix + "id", mirrored.getId());
                result.put(repoPrefix + "url", mirrored.getUrl());
            }
        }
        if (this.context.httpProxy() != null) {
            HTTPProxy proxy = this.context.httpProxy();
            result.put("session.httpProxy", String.format("%s://%s:%s", proxy.getProtocol(), proxy.getHost(), proxy.getPort()));
            result.put("session.nonProxyHosts", proxy.getNonProxyHosts());
        }
        return Result.success(result);
    }

    @Override
    public ToolboxResolver getToolboxResolver() {
        return this.toolboxResolver;
    }

    @Override
    public ToolboxSearchApi getToolboxSearchApi() {
        return this.toolboxSearchApi;
    }

    @Override
    public ArtifactMapper parseArtifactMapperSpec(String spec) {
        return ArtifactMapper.build(this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public ArtifactMatcher parseArtifactMatcherSpec(String spec) {
        return ArtifactMatcher.build(this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public ArtifactNameMapper parseArtifactNameMapperSpec(String spec) {
        return ArtifactNameMapper.build(this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public DependencyMatcher parseDependencyMatcherSpec(String spec) {
        return DependencyMatcher.build(this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public ArtifactVersionMatcher parseArtifactVersionMatcherSpec(String spec) {
        return ArtifactVersionMatcher.build(this.versionScheme, this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public ArtifactVersionSelector parseArtifactVersionSelectorSpec(String spec) {
        return ArtifactVersionSelector.build(this.versionScheme, this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public ArtifactKeyFactory parseArtifactKeyFactorySpec(String spec) {
        return ArtifactKeyFactory.build(this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public ArtifactDifferentiator parseArtifactDifferentiatorSpec(String spec) {
        return ArtifactDifferentiator.build(this.context.repositorySystemSession().getConfigProperties(), spec);
    }

    @Override
    public RemoteRepository parseRemoteRepository(String spec) {
        return this.toolboxResolver.parseRemoteRepository(spec);
    }

    @Override
    public Source<Artifact> artifactSource(String spec) {
        return ArtifactSources.build(this.context.repositorySystemSession().getConfigProperties(), this, spec);
    }

    @Override
    public Sink<Artifact> artifactSink(String spec, boolean dryRun) {
        return ArtifactSinks.build(this.context.repositorySystemSession().getConfigProperties(), this, dryRun, spec);
    }

    @Override
    public Sink<Dependency> dependencySink(String spec, boolean dryRun) {
        return DependencySinks.build(this.context.repositorySystemSession().getConfigProperties(), this, dryRun, spec);
    }

    @Override
    public ResolutionRoot loadGav(String gav, Collection<String> boms) throws InvalidVersionSpecificationException, VersionRangeResolutionException, ArtifactDescriptorException {
        return this.toolboxResolver.loadGav(gav, boms);
    }

    @Override
    public Artifact toArtifact(Dependency dependency) {
        try {
            return this.toolboxResolver.mayResolveArtifactVersion(dependency.getArtifact(), ArtifactVersionSelector.last());
        }
        catch (VersionRangeResolutionException | InvalidVersionSpecificationException e) {
            this.output.warn("Could not resolve artifact version: {}", dependency.getArtifact(), e);
            return dependency.getArtifact();
        }
    }

    protected String classpath(DependencyResult dependencyResult) {
        StringBuilder buffer = new StringBuilder(1024);
        for (ArtifactResult artifactResult : dependencyResult.getArtifactResults()) {
            Artifact artifact = artifactResult.getArtifact();
            if (artifact.getFile() == null) continue;
            if (!buffer.isEmpty()) {
                buffer.append(File.pathSeparatorChar);
            }
            buffer.append(artifact.getFile().getAbsolutePath());
        }
        return buffer.toString();
    }

    protected List<Artifact> resolvedArtifacts(DependencyResult dependencyResult) {
        return dependencyResult.getArtifactResults().stream().filter(ArtifactResult::isResolved).map(r -> ToolboxCommandoImpl.origin(r.getArtifact(), r.getRepository())).toList();
    }

    @Override
    public Result<String> classpath(ResolutionScope resolutionScope, Collection<ResolutionRoot> resolutionRoots) throws Exception {
        DependencyResult dependencyResult;
        if (resolutionRoots.size() == 1) {
            ResolutionRoot resolutionRoot = resolutionRoots.iterator().next();
            this.output.suggest("Resolving {}", resolutionRoot.getArtifact());
            dependencyResult = this.toolboxResolver.resolve(resolutionScope, this.toolboxResolver.loadRoot(resolutionRoot));
        } else if (resolutionRoots.size() > 1) {
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>(resolutionRoots.size());
            for (ResolutionRoot resolutionRoot : resolutionRoots) {
                if (!resolutionRoot.isLoad()) {
                    throw new IllegalArgumentException("Cannot resolve non-load dependency: " + String.valueOf(resolutionRoot));
                }
                this.output.suggest("Resolving as dependency {}", resolutionRoot.getArtifact());
                dependencies.add(new Dependency(resolutionRoot.getArtifact(), "compile"));
            }
            dependencyResult = this.toolboxResolver.resolve(resolutionScope, ResolutionRoot.ofNotLoaded((Artifact)new DefaultArtifact("fake:fake:1.0")).withDependencies(dependencies).build());
        } else {
            return Result.success("");
        }
        String classpathString = this.classpath(dependencyResult);
        this.output.doTell(classpathString, new Object[0]);
        return Result.success(classpathString);
    }

    @Override
    public Result<List<Artifact>> classpathList(ResolutionScope resolutionScope, Collection<ResolutionRoot> resolutionRoots, boolean details) throws Exception {
        DependencyResult dependencyResult;
        if (resolutionRoots.size() == 1) {
            ResolutionRoot resolutionRoot = resolutionRoots.iterator().next();
            this.output.suggest("Resolving {}", resolutionRoot.getArtifact());
            dependencyResult = this.toolboxResolver.resolve(resolutionScope, this.toolboxResolver.loadRoot(resolutionRoot));
        } else if (resolutionRoots.size() > 1) {
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>(resolutionRoots.size());
            for (ResolutionRoot resolutionRoot : resolutionRoots) {
                if (!resolutionRoot.isLoad()) {
                    throw new IllegalArgumentException("Cannot resolve non-load dependency: " + String.valueOf(resolutionRoot));
                }
                this.output.suggest("Resolving as dependency {}", resolutionRoot.getArtifact());
                dependencies.add(new Dependency(resolutionRoot.getArtifact(), "compile"));
            }
            dependencyResult = this.toolboxResolver.resolve(resolutionScope, ResolutionRoot.ofNotLoaded((Artifact)new DefaultArtifact("fake:fake:1.0")).withDependencies(dependencies).build());
        } else {
            return Result.success(List.of());
        }
        List<Artifact> result = this.resolvedArtifacts(dependencyResult);
        try (ArtifactSinks.StatArtifactSink sink = ArtifactSinks.statArtifactSink(0, true, details, this.output);){
            sink.accept(result);
        }
        return Result.success(result);
    }

    @Override
    public Result<Map<String, String>> classpathDiff(ResolutionScope resolutionScope, ResolutionRoot resolutionRoot1, ResolutionRoot resolutionRoot2, boolean unified) throws Exception {
        this.output.suggest("Resolving {}", resolutionRoot1.getArtifact());
        DependencyResult dependencyResult1 = this.toolboxResolver.resolve(resolutionScope, this.toolboxResolver.loadRoot(resolutionRoot1));
        this.output.suggest("Resolving {}", resolutionRoot2.getArtifact());
        DependencyResult dependencyResult2 = this.toolboxResolver.resolve(resolutionScope, this.toolboxResolver.loadRoot(resolutionRoot2));
        new ArtifactListComparator(this.output, unified).compare(resolutionRoot1.getArtifact(), this.resolvedArtifacts(dependencyResult1), resolutionRoot2.getArtifact(), this.resolvedArtifacts(dependencyResult2));
        return Result.success(Map.of(this.classpath(dependencyResult1), this.classpath(dependencyResult2)));
    }

    @Override
    public Result<Map<String, String>> classpathConflict(ResolutionScope resolutionScope, ResolutionRoot resolutionRoot1, ResolutionRoot resolutionRoot2, ArtifactKeyFactory artifactKeyFactory, Map<String, Function<Artifact, String>> differentiators) throws Exception {
        this.output.suggest("Resolving {}", resolutionRoot1.getArtifact());
        DependencyResult dependencyResult1 = this.toolboxResolver.resolve(resolutionScope, this.toolboxResolver.loadRoot(resolutionRoot1));
        this.output.suggest("Resolving {}", resolutionRoot2.getArtifact());
        DependencyResult dependencyResult2 = this.toolboxResolver.resolve(resolutionScope, this.toolboxResolver.loadRoot(resolutionRoot2));
        new ArtifactConflictComparator(this.output, artifactKeyFactory, differentiators).compare(resolutionRoot1.getArtifact(), this.resolvedArtifacts(dependencyResult1), resolutionRoot2.getArtifact(), this.resolvedArtifacts(dependencyResult2));
        return Result.success(Map.of(this.classpath(dependencyResult1), this.classpath(dependencyResult2)));
    }

    @Override
    public Result<List<Artifact>> copy(Source<Artifact> source, Sink<Artifact> sink) throws Exception {
        try (Source<Artifact> source2 = source;){
            Result<List<Artifact>> result;
            block12: {
                Sink<Artifact> sink2 = sink;
                try {
                    ArtifactSinks.CollectingArtifactSink collectingArtifactSink = ArtifactSinks.collectingArtifactSink();
                    ArtifactSinks.teeArtifactSink(sink, collectingArtifactSink).accept(source.get().map(a -> {
                        try {
                            if (a.getFile() == null) {
                                ArtifactResult ar = this.toolboxResolver.resolveArtifact((Artifact)a);
                                if (ar.isResolved()) {
                                    return ToolboxCommandoImpl.origin(ar.getArtifact(), ar.getRepository());
                                }
                                return null;
                            }
                            return a;
                        }
                        catch (ArtifactResolutionException e) {
                            throw new RuntimeException(e);
                        }
                    }).filter(Objects::nonNull));
                    this.output.tell("Copied {} artifacts", collectingArtifactSink.collect().size());
                    result = Result.success(collectingArtifactSink.collect());
                    if (sink2 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (sink2 != null) {
                        try {
                            sink2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sink2.close();
            }
            return result;
        }
    }

    @Override
    public Result<List<Artifact>> copyTransitive(ResolutionScope resolutionScope, Collection<ResolutionRoot> resolutionRoots, Sink<Artifact> sink) throws Exception {
        ArrayList<Artifact> artifactResults = new ArrayList<Artifact>();
        for (ResolutionRoot resolutionRoot : resolutionRoots) {
            this.output.suggest("Resolving {}", resolutionRoot.getArtifact());
            resolutionRoot = this.toolboxResolver.loadRoot(resolutionRoot);
            DependencyResult dependencyResult = this.toolboxResolver.resolve(resolutionScope, this.toolboxResolver.loadRoot(resolutionRoot));
            artifactResults.addAll(dependencyResult.getArtifactResults().stream().filter(ArtifactResult::isResolved).map(r -> ToolboxCommandoImpl.origin(r.getArtifact(), r.getRepository())).toList());
        }
        return this.copy(artifactResults::stream, sink);
    }

    @Override
    public Result<List<Artifact>> copyRecorded(boolean stopRecording, Sink<Artifact> sink) throws Exception {
        this.artifactRecorder.setActive(!stopRecording);
        return this.copy(this.artifactRecorder, sink);
    }

    @Override
    public Result<Map<String, List<RemoteRepository>>> listRepositories(ResolutionScope resolutionScope, Map<String, ResolutionRoot> resolutionRoots) throws Exception {
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        for (Map.Entry<String, ResolutionRoot> entry : resolutionRoots.entrySet()) {
            String contextName = entry.getKey();
            ResolutionRoot resolutionRoot = entry.getValue();
            this.output.chatter("Loading root of {} {}", contextName, resolutionRoot.getArtifact());
            ResolutionRoot root = this.toolboxResolver.loadRoot(resolutionRoot);
            this.output.chatter("Collecting graph of: {}", resolutionRoot.getArtifact());
            CollectResult collectResult = this.toolboxResolver.collect(resolutionScope, root.getArtifact(), root.getDependencies(), root.getManagedDependencies(), false);
            final LinkedHashMap repositories = new LinkedHashMap();
            final Dependency sentinel = new Dependency((Artifact)new DefaultArtifact("sentinel:sentinel:sentinel"), "");
            this.remoteRepositories().forEach(r -> repositories.put(r, sentinel));
            final ArrayDeque path = new ArrayDeque();
            collectResult.getRoot().accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){

                public boolean visitEnter(DependencyNode node) {
                    Dependency parent = path.peek() == null ? sentinel : (Dependency)path.peek();
                    node.getRepositories().forEach(r -> repositories.putIfAbsent(r, parent));
                    path.push(node.getDependency() != null ? node.getDependency() : sentinel);
                    return true;
                }

                public boolean visitLeave(DependencyNode node) {
                    path.pop();
                    return true;
                }
            }));
            if (repositories.isEmpty()) {
                this.output.tell("No remote repository is used by {} {}.", contextName, resolutionRoot.getArtifact());
                result.put(contextName, Collections.emptyList());
                continue;
            }
            this.output.tell("Remote repositories used by {} {}.", contextName, resolutionRoot.getArtifact());
            Map<Boolean, List<RemoteRepository>> repoGroupByMirrors = repositories.keySet().stream().collect(Collectors.groupingBy(repo -> repo.getMirroredRepositories().isEmpty()));
            repoGroupByMirrors.getOrDefault(Boolean.TRUE, Collections.emptyList()).forEach(r -> {
                this.output.tell(" * {}", r);
                Dependency firstIntroduced = (Dependency)repositories.get(r);
                this.output.tell("   First introduced on {}", firstIntroduced == sentinel ? "root" : firstIntroduced);
            });
            HashMap<RemoteRepository, RemoteRepository> mirrorMap = new HashMap<RemoteRepository, RemoteRepository>();
            repoGroupByMirrors.getOrDefault(Boolean.FALSE, Collections.emptyList()).forEach(repo -> repo.getMirroredRepositories().forEach(mrepo -> mirrorMap.put((RemoteRepository)mrepo, (RemoteRepository)repo)));
            mirrorMap.forEach((r, mirror) -> {
                this.output.tell(" * {}", r);
                Dependency firstIntroduced = (Dependency)repositories.get(mirror);
                this.output.tell("   First introduced on {}", firstIntroduced == sentinel ? "root" : firstIntroduced);
                this.output.tell("   Mirrored by {}", mirror);
            });
            result.put(contextName, List.copyOf(repositories.keySet()));
        }
        return Result.success(result);
    }

    @Override
    public Result<List<Artifact>> listAvailablePlugins(Collection<String> groupIds) throws Exception {
        this.output.suggest("Listing plugins in groupIds: {}", groupIds);
        List<Artifact> plugins = this.toolboxResolver.listAvailablePlugins(groupIds);
        plugins.forEach(p -> this.output.tell(p.toString(), new Object[0]));
        return plugins.isEmpty() ? Result.failure("No plugins") : Result.success(plugins);
    }

    @Override
    public Result<String> recordStart() {
        boolean result = this.artifactRecorder.setActive(true);
        if (result) {
            this.artifactRecorder.clear();
            this.output.tell("Started recorder...", new Object[0]);
        } else {
            this.output.tell("Recorder was already started.", new Object[0]);
        }
        return result ? Result.success("Started") : Result.failure("No recorder state changed");
    }

    @Override
    public Result<ToolboxCommando.RecordStats> recordStats() {
        boolean active = this.artifactRecorder.isActive();
        int recordedCount = this.artifactRecorder.recordedCount();
        this.output.tell("Recorder is {}; recorded {} artifacts so far", active ? "started" : "stopped", recordedCount);
        return Result.success(new ToolboxCommando.RecordStats(active, recordedCount));
    }

    @Override
    public Result<String> recordStop() {
        boolean result = this.artifactRecorder.setActive(false);
        if (result) {
            this.output.tell("Stopped recorder, recorded {} artifacts", this.artifactRecorder.recordedCount());
        } else {
            this.output.tell("Recorder was not started.", new Object[0]);
        }
        return result ? Result.success("Stopped") : Result.failure("No recorder state changed");
    }

    @Override
    public Result<Path> localRepository() throws Exception {
        Result<Path> result = Result.success(this.session.getLocalRepository().getBasedir().toPath());
        result.getData().ifPresent(path -> this.output.tell(path.toString(), new Object[0]));
        return result;
    }

    @Override
    public Result<Path> artifactPath(Artifact artifact, RemoteRepository repository) throws Exception {
        Result<Path> result = repository == null ? Result.success(Path.of(this.session.getLocalRepositoryManager().getPathForLocalArtifact(artifact), new String[0])) : Result.success(Path.of(this.session.getLocalRepositoryManager().getPathForRemoteArtifact(artifact, repository, "toolbox"), new String[0]));
        result.getData().ifPresent(path -> this.output.tell(path.toString(), new Object[0]));
        return result;
    }

    @Override
    public Result<Path> metadataPath(Metadata metadata, RemoteRepository repository) throws Exception {
        Result<Path> result = repository == null ? Result.success(Path.of(this.session.getLocalRepositoryManager().getPathForLocalMetadata(metadata), new String[0])) : Result.success(Path.of(this.session.getLocalRepositoryManager().getPathForRemoteMetadata(metadata, repository, "toolbox"), new String[0]));
        result.getData().ifPresent(path -> this.output.tell(path.toString(), new Object[0]));
        return result;
    }

    @Override
    public Result<List<Artifact>> resolve(Source<Artifact> artifactSource, boolean sources, boolean javadoc, boolean signature, Sink<Artifact> sink) throws Exception {
        ArrayList result = new ArrayList();
        List<Artifact> artifacts = artifactSource.get().collect(Collectors.toList());
        this.output.suggest("Resolving {}", artifacts);
        try (ArtifactSinks.TeeArtifactSink artifactSink = ArtifactSinks.teeArtifactSink(sink, ArtifactSinks.statArtifactSink(0, true, true, this.output));){
            List artifactResults = this.toolboxResolver.resolveArtifacts(artifacts).stream().map(r -> ToolboxCommandoImpl.origin(r.getArtifact(), r.getRepository())).collect(Collectors.toList());
            result.addAll(artifactResults);
            artifactSink.accept(artifactResults);
            if (sources || javadoc || signature) {
                HashSet<Artifact> subartifacts = new HashSet<Artifact>();
                artifacts.forEach(a -> {
                    if (sources && a.getClassifier().isEmpty()) {
                        subartifacts.add((Artifact)new SubArtifact(a, "sources", "jar"));
                    }
                    if (javadoc && a.getClassifier().isEmpty()) {
                        subartifacts.add((Artifact)new SubArtifact(a, "javadoc", "jar"));
                    }
                    if (signature && !a.getExtension().endsWith(".asc")) {
                        subartifacts.add((Artifact)new SubArtifact(a, "*", "*.asc"));
                    }
                });
                if (!subartifacts.isEmpty()) {
                    this.output.suggest("Resolving (best effort) {}", subartifacts);
                    try {
                        List subartifactResults = this.toolboxResolver.resolveArtifacts(subartifacts).stream().map(r -> ToolboxCommandoImpl.origin(r.getArtifact(), r.getRepository())).collect(Collectors.toList());
                        result.addAll(subartifactResults);
                        artifactSink.accept(subartifactResults);
                    }
                    catch (ArtifactResolutionException e) {
                        List bestEffort = e.getResults().stream().filter(ArtifactResult::isResolved).map(r -> ToolboxCommandoImpl.origin(r.getArtifact(), r.getRepository())).collect(Collectors.toList());
                        result.addAll(bestEffort);
                        artifactSink.accept(bestEffort);
                    }
                }
            }
            Result<List<Artifact>> result2 = result.isEmpty() ? Result.failure("No artifacts") : Result.success(result);
            return result2;
        }
    }

    @Override
    public Result<List<Artifact>> resolveTransitive(ResolutionScope resolutionScope, Collection<ResolutionRoot> resolutionRoots, boolean sources, boolean javadoc, boolean signature, Sink<Artifact> sink) throws Exception {
        ArtifactSinks.StatArtifactSink stat = ArtifactSinks.statArtifactSink(0, false, false, this.output);
        try (ArtifactSinks.TeeArtifactSink artifactSink = ArtifactSinks.teeArtifactSink(sink, stat);){
            for (ResolutionRoot resolutionRoot : resolutionRoots) {
                this.doResolveTransitive(resolutionScope, resolutionRoot, sources, javadoc, signature, ArtifactSinks.teeArtifactSink(ArtifactSinks.nonClosingArtifactSink(artifactSink), ArtifactSinks.statArtifactSink(1, true, true, this.output)));
            }
        }
        return stat.getSeenArtifacts().isEmpty() ? Result.failure("No artifacts") : Result.success(stat.getSeenArtifacts());
    }

    protected void doResolveTransitive(ResolutionScope resolutionScope, ResolutionRoot resolutionRoot, boolean sources, boolean javadoc, boolean signature, Sink<Artifact> sink) throws Exception {
        try (Sink<Artifact> artifactSink = sink;){
            this.output.marker(Output.Verbosity.NORMAL).emphasize("Resolving ").outstanding(ArtifactIdUtils.toId((Artifact)resolutionRoot.getArtifact())).say(new Object[0]);
            DependencyResult dependencyResult = this.toolboxResolver.resolve(resolutionScope, this.toolboxResolver.loadRoot(resolutionRoot));
            artifactSink.accept(dependencyResult.getArtifactResults().stream().map(r -> ToolboxCommandoImpl.origin(r.getArtifact(), r.getRepository())).collect(Collectors.toList()));
            if (sources || javadoc || signature) {
                HashSet<Artifact> subartifacts = new HashSet<Artifact>();
                dependencyResult.getArtifactResults().stream().map(r -> ToolboxCommandoImpl.origin(r.getArtifact(), r.getRepository())).forEach(a -> {
                    if (sources && a.getClassifier().isEmpty()) {
                        subartifacts.add((Artifact)new SubArtifact(a, "sources", "jar"));
                    }
                    if (javadoc && a.getClassifier().isEmpty()) {
                        subartifacts.add((Artifact)new SubArtifact(a, "javadoc", "jar"));
                    }
                    if (signature && !a.getExtension().endsWith(".asc")) {
                        subartifacts.add((Artifact)new SubArtifact(a, "*", "*.asc"));
                    }
                });
                if (!subartifacts.isEmpty()) {
                    this.output.suggest("Resolving (best effort) {}", subartifacts);
                    try {
                        List<ArtifactResult> subartifactResults = this.toolboxResolver.resolveArtifacts(subartifacts);
                        artifactSink.accept(subartifactResults.stream().map(r -> ToolboxCommandoImpl.origin(r.getArtifact(), r.getRepository())).collect(Collectors.toList()));
                    }
                    catch (ArtifactResolutionException e) {
                        artifactSink.accept(e.getResults().stream().filter(ArtifactResult::isResolved).map(r -> ToolboxCommandoImpl.origin(r.getArtifact(), r.getRepository())).collect(Collectors.toList()));
                    }
                }
            }
        }
    }

    @Override
    public Result<CollectResult> tree(ResolutionScope resolutionScope, ResolutionRoot resolutionRoot, boolean verboseTree, DependencyMatcher dependencyMatcher) throws Exception {
        CollectResult collectResult = this.doTree(resolutionScope, resolutionRoot, verboseTree, dependencyMatcher);
        collectResult.getRoot().accept((DependencyVisitor)new DependencyGraphDumper(x$0 -> this.output.tell((String)x$0, new Object[0]), DependencyGraphDumper.defaultsWith(new Function[0]), this.output.tool(DependencyGraphDecorators.TreeDecorator.class, DependencyGraphDecorators.defaultSupplier())));
        return Result.success(collectResult);
    }

    @Override
    public Result<Map<CollectResult, CollectResult>> treeDiff(ResolutionScope resolutionScope, ResolutionRoot resolutionRoot1, ResolutionRoot resolutionRoot2, boolean verboseTree, DependencyMatcher dependencyMatcher) throws Exception {
        CollectResult collectResult1 = this.doTree(resolutionScope, resolutionRoot1, verboseTree, dependencyMatcher);
        CollectResult collectResult2 = this.doTree(resolutionScope, resolutionRoot2, verboseTree, dependencyMatcher);
        new DependencyGraphComparator(x$0 -> this.output.tell((String)x$0, new Object[0]), DependencyGraphDumper.defaultsWith(new Function[0]), this.output.tool(DependencyGraphDecorators.TreeDecorator.class, DependencyGraphDecorators.defaultSupplier())).compare(collectResult1.getRoot(), collectResult2.getRoot());
        return Result.success(Map.of(collectResult1, collectResult2));
    }

    protected CollectResult doTree(ResolutionScope resolutionScope, ResolutionRoot resolutionRoot, boolean verboseTree, final DependencyMatcher dependencyMatcher) throws Exception {
        this.output.suggest("Loading root of: {}", resolutionRoot.getArtifact());
        ResolutionRoot root = this.toolboxResolver.loadRoot(resolutionRoot);
        this.output.suggest("Collecting graph of: {}", resolutionRoot.getArtifact());
        CollectResult collectResult = this.toolboxResolver.collect(resolutionScope, root.getArtifact(), root.getDependencies(), root.getManagedDependencies(), verboseTree);
        CloningDependencyVisitor cloningDependencyVisitor = new CloningDependencyVisitor();
        collectResult.getRoot().accept((DependencyVisitor)new FilteringDependencyVisitor((DependencyVisitor)cloningDependencyVisitor, new DependencyFilter(){

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                return node.getDependency() == null || dependencyMatcher.test(node.getDependency());
            }
        }));
        DependencyNode clone = cloningDependencyVisitor.getRootNode();
        collectResult.setRoot(clone);
        return collectResult;
    }

    @Override
    public Result<CollectResult> dirtyTree(ResolutionScope resolutionScope, ResolutionRoot resolutionRoot, int maxLevel, boolean verboseTree, final DependencyMatcher dependencyMatcher) throws Exception {
        this.output.suggest("Loading root of: {}", resolutionRoot.getArtifact());
        ResolutionRoot root = this.toolboxResolver.loadRoot(resolutionRoot);
        this.output.suggest("Collecting graph of: {}", resolutionRoot.getArtifact());
        CollectResult collectResult = this.toolboxResolver.collect(resolutionScope, root.getArtifact(), root.getDependencies(), root.getManagedDependencies(), maxLevel, verboseTree);
        CloningDependencyVisitor cloningDependencyVisitor = new CloningDependencyVisitor();
        collectResult.getRoot().accept((DependencyVisitor)new FilteringDependencyVisitor((DependencyVisitor)cloningDependencyVisitor, new DependencyFilter(){

            public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                return node.getDependency() == null || dependencyMatcher.test(node.getDependency());
            }
        }));
        DependencyNode clone = cloningDependencyVisitor.getRootNode();
        clone.accept((DependencyVisitor)new TreeDependencyVisitor((DependencyVisitor)new DependencyGraphDumper(x$0 -> this.output.tell((String)x$0, new Object[0]), DependencyGraphDumper.defaultsWith(new Function[0]), this.output.tool(DependencyGraphDecorators.TreeDecorator.class, DependencyGraphDecorators.defaultSupplier()))));
        collectResult.setRoot(clone);
        return Result.success(collectResult);
    }

    @Override
    public Result<List<List<Artifact>>> treeFind(ResolutionScope resolutionScope, ResolutionRoot resolutionRoot, boolean verboseTree, ArtifactMatcher artifactMatcher) throws Exception {
        this.output.suggest("Loading root of: {}", resolutionRoot.getArtifact());
        ResolutionRoot root = this.toolboxResolver.loadRoot(resolutionRoot);
        this.output.suggest("Collecting graph of: {}", resolutionRoot.getArtifact());
        CollectResult collectResult = this.toolboxResolver.collect(resolutionScope, root.getArtifact(), root.getDependencies(), root.getManagedDependencies(), verboseTree);
        PathRecordingDependencyVisitor pathRecordingDependencyVisitor = new PathRecordingDependencyVisitor((node, parents) -> node.getArtifact() != null && artifactMatcher.test(node.getArtifact()));
        collectResult.getRoot().accept((DependencyVisitor)pathRecordingDependencyVisitor);
        ArrayList result = new ArrayList();
        if (!pathRecordingDependencyVisitor.getPaths().isEmpty()) {
            for (List path : pathRecordingDependencyVisitor.getPaths()) {
                result.add(path.stream().map(DependencyNode::getArtifact).collect(Collectors.toList()));
                Object indent = "";
                for (DependencyNode node2 : path) {
                    this.output.tell("{}-> {}", indent, node2.getDependency() != null ? node2.getDependency() : node2.getArtifact());
                    indent = (String)indent + "  ";
                }
            }
        }
        return Result.success(result);
    }

    @Override
    public Result<List<Dependency>> dmList(ResolutionRoot resolutionRoot, boolean verboseList) throws Exception {
        AtomicInteger counter = new AtomicInteger(0);
        List<Dependency> result = this.toolboxResolver.loadRoot(resolutionRoot).getManagedDependencies();
        result.forEach(d -> this.output.tell(" {}. {}", counter.incrementAndGet(), d.getScope().trim().isEmpty() ? d.getArtifact() : d));
        return Result.success(result);
    }

    @Override
    public Result<CollectResult> dmTree(ResolutionRoot resolutionRoot, boolean verboseTree) throws Exception {
        resolutionRoot = this.toolboxResolver.loadRoot(resolutionRoot);
        CollectResult collectResult = this.toolboxResolver.collectDm(resolutionRoot.getArtifact(), resolutionRoot.getManagedDependencies(), verboseTree);
        collectResult.getRoot().accept((DependencyVisitor)new DependencyGraphDumper(x$0 -> this.output.tell((String)x$0, new Object[0]), DependencyGraphDumper.defaultsWith(new Function[0]), this.output.tool(DependencyGraphDecorators.DmTreeDecorator.class, DependencyGraphDecorators.defaultSupplier())));
        return Result.success(collectResult);
    }

    @Override
    public Result<CollectResult> parentChildTree(ReactorLocator reactorLocator) {
        CollectResult collectResult = this.toolboxResolver.parentChildTree(reactorLocator);
        collectResult.getRoot().accept((DependencyVisitor)new DependencyGraphDumper(x$0 -> this.output.tell((String)x$0, new Object[0]), DependencyGraphDumper.defaultsWith(new Function[0]), this.output.tool(DependencyGraphDecorators.ParentChildTreeDecorator.class, DependencyGraphDecorators.defaultSupplier())));
        return Result.success(collectResult);
    }

    @Override
    public Result<CollectResult> subprojectTree(ReactorLocator reactorLocator) throws Exception {
        CollectResult collectResult = this.toolboxResolver.subprojectTree(reactorLocator);
        collectResult.getRoot().accept((DependencyVisitor)new DependencyGraphDumper(x$0 -> this.output.tell((String)x$0, new Object[0]), DependencyGraphDumper.defaultsWith(new Function[0]), this.output.tool(DependencyGraphDecorators.SubprojectTreeDecorator.class, DependencyGraphDecorators.defaultSupplier())));
        return Result.success(collectResult);
    }

    @Override
    public Result<Collection<DependencyNode>> projectDependencyTree(ReactorLocator reactorLocator, boolean showExternal, ArtifactMatcher excludeSubprojectsMatcher, DependencyMatcher excludeDependencyMatcher) throws IOException {
        List<DependencyNode> collectResult = this.toolboxResolver.projectDependencyTree(reactorLocator, showExternal, excludeSubprojectsMatcher, excludeDependencyMatcher);
        collectResult.forEach(r -> r.accept((DependencyVisitor)new DependencyGraphDumper(x$0 -> this.output.tell((String)x$0, new Object[0]), DependencyGraphDumper.defaultsWith(new Function[0]), this.output.tool(DependencyGraphDecorators.ProjectDependenciesTreeDecorator.class, DependencyGraphDecorators.defaultSupplier()))));
        return Result.success(collectResult);
    }

    @Override
    public Result<Map<ReactorLocator.ReactorProject, Collection<Dependency>>> projectDependencyGraph(ReactorLocator reactorLocator, boolean showExternal, ArtifactMatcher excludeSubprojectsMatcher, DependencyMatcher excludeDependencyMatcher, Path output) throws IOException {
        Map<ReactorLocator.ReactorProject, Collection<Dependency>> result = this.toolboxGraph.projectDependencyGraph(reactorLocator, showExternal, excludeSubprojectsMatcher, excludeDependencyMatcher);
        Map<Artifact, String> labels = this.toolboxGraph.labels(result);
        MutableGraph g = ((MutableGraph)Factory.mutGraph((String)"reactor").setDirected(true).graphAttrs().add((Attributes)Label.of((String)ArtifactIdUtils.toId((Artifact)reactorLocator.getTopLevelProject().artifact())))).use((gr, ctx) -> {
            for (Map.Entry entry : result.entrySet()) {
                MutableNode from = Factory.mutNode((String)((String)labels.get(((ReactorLocator.ReactorProject)entry.getKey()).artifact()))).add((Attributes)Color.BLUE).add((Attributes)Shape.BOX);
                for (Dependency dependency : (Collection)entry.getValue()) {
                    Shape shape;
                    Color color;
                    String source = dependency.getArtifact().getProperty("source", "internal");
                    if ("internal".equals(source)) {
                        color = Color.BLUE;
                        shape = Shape.BOX;
                    } else {
                        color = Color.GREEN;
                        shape = Shape.ELLIPSE;
                    }
                    from.addLink((LinkTarget)Factory.mutNode((String)((String)labels.get(dependency.getArtifact()))).add((Attributes)color).add((Attributes)shape));
                }
            }
        });
        Graphviz.fromGraph((MutableGraph)g).render(Format.SVG).toFile(output.toFile());
        return Result.success(result);
    }

    @Override
    public Result<String> modelToString(Model model, boolean verbose) throws Exception {
        String result;
        if (verbose) {
            StringWriter sw = new StringWriter();
            MavenXpp3WriterEx mavenXpp3WriterEx = new MavenXpp3WriterEx();
            mavenXpp3WriterEx.setStringFormatter((InputLocation.StringFormatter)new InputLocationStringFormatter());
            mavenXpp3WriterEx.write((Writer)sw, model);
            result = sw.toString().replaceAll(" \\{-->", " -->\n");
        } else {
            StringWriter sw = new StringWriter();
            new MavenXpp3Writer().write((Writer)sw, model);
            result = sw.toString();
        }
        return Result.success(result);
    }

    @Override
    public Result<Model> effectiveModel(ResolutionRoot resolutionRoot) throws Exception {
        if (!resolutionRoot.isLoad()) {
            throw new IllegalArgumentException("only loaded roots can be shown as effective model");
        }
        return Result.success(this.toolboxResolver.readModel(resolutionRoot.getArtifact()).getEffectiveModel());
    }

    @Override
    public Result<Model> effectiveModel(ReactorLocator reactorLocator) throws Exception {
        Objects.requireNonNull(reactorLocator);
        return Result.success(reactorLocator.getSelectedOrCurrentProject().effectiveModel());
    }

    @Override
    public Result<Model> flattenBOM(Artifact artifact, ResolutionRoot resolutionRoot) throws Exception {
        Objects.requireNonNull(artifact);
        Objects.requireNonNull(resolutionRoot);
        ModelResponse response = this.toolboxResolver.readModel(resolutionRoot.getArtifact());
        Model resultModel = new MavenXpp3Reader().read((Reader)new StringReader(PomSuppliers.empty400(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion())));
        resultModel.setPackaging("pom");
        resultModel.setDependencyManagement(new DependencyManagement());
        Model bomModel = response.getEffectiveModel();
        if (bomModel.getDependencyManagement() != null) {
            for (org.apache.maven.model.Dependency dependency : bomModel.getDependencyManagement().getDependencies()) {
                resultModel.getDependencyManagement().addDependency(dependency);
            }
        }
        return Result.success(resultModel);
    }

    @Override
    public Result<Model> flattenBOM(Artifact artifact, ReactorLocator reactorLocator) throws Exception {
        Objects.requireNonNull(artifact);
        Objects.requireNonNull(reactorLocator);
        Model resultModel = new MavenXpp3Reader().read((Reader)new StringReader(PomSuppliers.empty400(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion())));
        resultModel.setPackaging("pom");
        resultModel.setDependencyManagement(new DependencyManagement());
        Model bomModel = reactorLocator.getSelectedOrCurrentProject().effectiveModel();
        if (bomModel.getDependencyManagement() != null) {
            for (org.apache.maven.model.Dependency dependency : bomModel.getDependencyManagement().getDependencies()) {
                resultModel.getDependencyManagement().addDependency(dependency);
            }
        }
        return Result.success(resultModel);
    }

    @Override
    public Map<String, RemoteRepository> getKnownSearchRemoteRepositories() {
        return this.knownSearchRemoteRepositories;
    }

    @Override
    public Result<Map<Artifact, Boolean>> exists(RemoteRepository remoteRepository, String gav, boolean pom, boolean sources, boolean javadoc, boolean signature, boolean allRequired, String repositoryVendor) throws IOException {
        HashMap<Object, Boolean> result = new HashMap<Object, Boolean>();
        ArrayList<Object> missingOnes = new ArrayList<Object>();
        ArrayList<Object> existingOnes = new ArrayList<Object>();
        try (SearchBackend backend = this.toolboxSearchApi.getRemoteRepositoryBackend(this.context.repositorySystemSession(), remoteRepository, repositoryVendor);){
            DefaultArtifact artifact = new DefaultArtifact(gav);
            boolean exists = this.toolboxSearchApi.exists(backend, (Artifact)artifact);
            result.put(artifact, exists);
            if (!exists) {
                missingOnes.add(artifact);
            } else {
                existingOnes.add(artifact);
            }
            BiConsumer<Artifact, Boolean> reporter = (a, e) -> {
                if (e.booleanValue()) {
                    this.output.marker(Output.Verbosity.NORMAL).normal("Artifact {} ").outstanding("EXISTS").say(a);
                } else {
                    this.output.marker(Output.Verbosity.NORMAL).normal("Artifact {} ").scary("NOT EXISTS").say(a);
                }
            };
            reporter.accept((Artifact)artifact, exists);
            if (pom && !"pom".equals(artifact.getExtension())) {
                SubArtifact poma = new SubArtifact((Artifact)artifact, null, "pom");
                exists = this.toolboxSearchApi.exists(backend, (Artifact)poma);
                result.put(poma, exists);
                if (!exists && allRequired) {
                    missingOnes.add(poma);
                } else if (allRequired) {
                    existingOnes.add(poma);
                }
                reporter.accept((Artifact)poma, exists);
            }
            if (sources) {
                SubArtifact sourcesa = new SubArtifact((Artifact)artifact, "sources", "jar");
                exists = this.toolboxSearchApi.exists(backend, (Artifact)sourcesa);
                result.put(sourcesa, exists);
                if (!exists && allRequired) {
                    missingOnes.add(sourcesa);
                } else if (allRequired) {
                    existingOnes.add(sourcesa);
                }
                reporter.accept((Artifact)sourcesa, exists);
            }
            if (javadoc) {
                SubArtifact javadoca = new SubArtifact((Artifact)artifact, "javadoc", "jar");
                exists = this.toolboxSearchApi.exists(backend, (Artifact)javadoca);
                result.put(javadoca, exists);
                if (!exists && allRequired) {
                    missingOnes.add(javadoca);
                } else if (allRequired) {
                    existingOnes.add(javadoca);
                }
                reporter.accept((Artifact)javadoca, exists);
            }
            if (signature) {
                SubArtifact signaturea = new SubArtifact((Artifact)artifact, null, artifact.getExtension() + ".asc");
                exists = this.toolboxSearchApi.exists(backend, (Artifact)signaturea);
                result.put(signaturea, exists);
                if (!exists && allRequired) {
                    missingOnes.add(signaturea);
                } else if (allRequired) {
                    existingOnes.add(signaturea);
                }
                reporter.accept((Artifact)signaturea, exists);
            }
        }
        this.output.tell("", new Object[0]);
        this.output.marker(Output.Verbosity.TIGHT).emphasize("Checked TOTAL of {} (existing: {} not existing: {})").say(existingOnes.size() + missingOnes.size(), existingOnes.size(), missingOnes.size());
        return missingOnes.isEmpty() ? Result.success(result) : Result.failure("Missing artifacts");
    }

    @Override
    public Result<Map<String, Artifact>> identify(RemoteRepository remoteRepository, Collection<String> targets, boolean decorated) throws IOException {
        Map<String, Artifact> result;
        HashMap<String, String> sha1s = new HashMap<String, String>();
        for (String target : targets) {
            Path tgt = Path.of(target, new String[0]);
            if (Files.exists(tgt, new LinkOption[0])) {
                try {
                    this.output.tell("Calculating SHA1 of file {}", target);
                    MessageDigest sha1md = MessageDigest.getInstance("SHA-1");
                    byte[] buf = new byte[8192];
                    try (InputStream fis = Files.newInputStream(tgt, new OpenOption[0]);){
                        int read = fis.read(buf);
                        while (read != -1) {
                            sha1md.update(buf, 0, read);
                            read = fis.read(buf);
                        }
                    }
                    sha1s.put(target, ChecksumUtils.toHexString((byte[])sha1md.digest()));
                    continue;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("SHA1 MessageDigest unavailable", e);
                }
            }
            sha1s.put(target, target);
        }
        try (SearchBackend backend = this.toolboxSearchApi.getSmoBackend(this.context.repositorySystemSession(), remoteRepository);){
            result = this.toolboxSearchApi.identify(this.session(), backend, sha1s.values());
        }
        sha1s.forEach((key, value) -> {
            String hit;
            Artifact a = (Artifact)result.get(value);
            String string = hit = a != null ? a.toString() : "UNKNOWN";
            if (decorated) {
                if (!Objects.equals(key, value)) {
                    this.output.marker(Output.Verbosity.TIGHT).outstanding("{} ({}) = {}").say(value, key, hit);
                } else {
                    this.output.marker(Output.Verbosity.TIGHT).outstanding("{} = {}").say(value, hit);
                }
            } else {
                this.output.marker(Output.Verbosity.TIGHT).outstanding(hit).say(new Object[0]);
            }
        });
        return result.isEmpty() ? Result.failure("No matches") : Result.success(result);
    }

    @Override
    public Result<List<String>> list(RemoteRepository remoteRepository, String gavoid, String repositoryVendor) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (SearchBackend backend = this.toolboxSearchApi.getRemoteRepositoryBackend(this.context.repositorySystemSession(), remoteRepository, repositoryVendor);){
            String[] elements = gavoid.split(":");
            if (elements.length < 1 || elements.length > 3) {
                throw new IllegalArgumentException("Invalid gavoid");
            }
            FieldQuery query = FieldQuery.fieldQuery((Field)MAVEN.GROUP_ID, (String)elements[0]);
            if (elements.length > 1) {
                query = BooleanQuery.and((Query)query, (Query[])new Query[]{FieldQuery.fieldQuery((Field)MAVEN.ARTIFACT_ID, (String)elements[1])});
            }
            Predicate<String> versionPredicate = null;
            if (elements.length > 2) {
                try {
                    VersionConstraint versionConstraint = this.versionScheme.parseVersionConstraint(elements[2]);
                    if (versionConstraint.getRange() != null) {
                        versionPredicate = s -> {
                            try {
                                return versionConstraint.containsVersion(this.versionScheme.parseVersion(s));
                            }
                            catch (InvalidVersionSpecificationException e) {
                                return false;
                            }
                        };
                    }
                }
                catch (InvalidVersionSpecificationException versionConstraint) {
                    // empty catch block
                }
                if (versionPredicate == null) {
                    query = BooleanQuery.and((Query)query, (Query[])new Query[]{FieldQuery.fieldQuery((Field)MAVEN.VERSION, (String)elements[2])});
                }
            }
            SearchRequest searchRequest = new SearchRequest((Query)query);
            SearchResponse searchResponse = backend.search(searchRequest);
            List<String> gavoids = this.toolboxSearchApi.renderGavoid(searchResponse.getPage(), versionPredicate);
            for (String g : gavoids) {
                result.add(g);
                this.output.tell(g, new Object[0]);
            }
        }
        return Result.success(result);
    }

    @Override
    public Result<List<Artifact>> search(RemoteRepository remoteRepository, String expression) throws IOException {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        try (SearchBackend backend = this.toolboxSearchApi.getSmoBackend(this.context.repositorySystemSession(), remoteRepository);){
            Query query;
            try {
                query = this.toolboxSearchApi.toSmoQuery((Artifact)new DefaultArtifact(expression));
            }
            catch (IllegalArgumentException e) {
                query = Query.query((String)expression);
            }
            SearchRequest searchRequest = new SearchRequest(query);
            SearchResponse searchResponse = backend.search(searchRequest);
            Collection<Artifact> artifacts = this.toolboxSearchApi.renderArtifacts(this.session(), searchResponse.getPage(), null);
            for (Artifact artifact : artifacts) {
                result.add(artifact);
                this.output.tell(artifact.toString(), new Object[0]);
                this.output.suggest(artifact.getProperties().toString(), new Object[0]);
            }
            while (searchResponse.getCurrentHits() > 0) {
                searchResponse = backend.search(searchResponse.getSearchRequest().nextPage());
                artifacts = this.toolboxSearchApi.renderArtifacts(this.session(), searchResponse.getPage(), null);
                for (Artifact artifact : artifacts) {
                    result.add(artifact);
                    this.output.tell(artifact.toString(), new Object[0]);
                    this.output.suggest(artifact.getProperties().toString(), new Object[0]);
                }
            }
        }
        return Result.success(result);
    }

    @Override
    public Result<Boolean> verify(RemoteRepository remoteRepository, String gav, String sha1, String repositoryVendor) throws IOException {
        try (SearchBackend backend = this.toolboxSearchApi.getRemoteRepositoryBackend(this.context.repositorySystemSession(), remoteRepository, repositoryVendor);){
            DefaultArtifact artifact = new DefaultArtifact(gav);
            boolean verified = this.toolboxSearchApi.verify(backend, (Artifact)new DefaultArtifact(gav), sha1);
            this.output.tell("Artifact SHA1({})={}: {}", artifact, sha1, verified ? "MATCHED" : "NOT MATCHED");
            Result<Boolean> result = Result.success(verified);
            return result;
        }
    }

    @Override
    public Result<Float> libYear(String subject, ResolutionScope resolutionScope, ResolutionRoot resolutionRoot, boolean transitive, boolean upToDate, Predicate<Version> versionPredicate, BiFunction<Artifact, List<Version>, String> artifactVersionSelector, String repositoryVendor) throws Exception {
        LibYearSink sink;
        ArrayList<SearchBackend> searchBackends = new ArrayList<SearchBackend>();
        for (RemoteRepository remoteRepository : this.context.remoteRepositories()) {
            searchBackends.add(this.toolboxSearchApi.getRemoteRepositoryBackend(this.context.repositorySystemSession(), remoteRepository, repositoryVendor));
        }
        try (LibYearSink libYearSink = sink = LibYearSink.libYear(this.output, subject, this.context, this.toolboxResolver, this.toolboxSearchApi, upToDate, versionPredicate, artifactVersionSelector, searchBackends);){
            try {
                final ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
                ResolutionRoot root = this.toolboxResolver.loadRoot(resolutionRoot);
                if (transitive) {
                    final CollectResult collectResult = this.toolboxResolver.collect(resolutionScope, root.getArtifact(), root.getDependencies(), root.getManagedDependencies(), false);
                    collectResult.getRoot().accept(new DependencyVisitor(){

                        public boolean visitEnter(DependencyNode node) {
                            if (node != collectResult.getRoot()) {
                                artifacts.add(node.getArtifact());
                            }
                            return true;
                        }

                        public boolean visitLeave(DependencyNode node) {
                            return true;
                        }
                    });
                } else {
                    artifacts.addAll(resolutionRoot.getDependencies().stream().map(this::toArtifact).toList());
                }
                sink.accept(artifacts);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Result.success(Float.valueOf(sink.getTotalLibyear()));
    }

    @Override
    public Result<Map<Artifact, List<Version>>> versions(String context, Source<Artifact> artifactSource, Predicate<Version> versionPredicate, BiFunction<Artifact, List<Version>, String> versionSelector) throws Exception {
        List<Artifact> artifacts = artifactSource.get().toList();
        HashMap<Artifact, List<Version>> result = new HashMap<Artifact, List<Version>>();
        this.output.marker(Output.Verbosity.NORMAL).emphasize("Checking newest versions of {} ({})").say(context, artifacts.size());
        for (Artifact artifact : artifacts) {
            List<Version> newer = this.toolboxResolver.findNewerVersions(artifact, versionPredicate);
            result.put(artifact, newer);
            if (!newer.isEmpty()) {
                boolean changed;
                String selected = versionSelector.apply(artifact, newer);
                boolean bl = changed = !Objects.equals(selected, artifact.getVersion());
                if (changed) {
                    this.output.marker(Output.Verbosity.NORMAL).scary("* {} -> {}").say(ArtifactIdUtils.toId((Artifact)artifact), selected);
                    this.output.marker(Output.Verbosity.SUGGEST).detail("  Available: {}").say(newer.stream().map(Object::toString).collect(Collectors.joining(", ")));
                    continue;
                }
            }
            this.output.marker(Output.Verbosity.NORMAL).outstanding("* {} is up to date").say(ArtifactIdUtils.toId((Artifact)artifact));
        }
        return Result.success(result);
    }

    @Override
    public ToolboxCommando.EditSession createEditSession(final Path pom) throws IOException {
        return new ToolboxCommando.EditSession(){
            private final FileUtils.CollocatedTempFile ctf;
            private final AtomicBoolean failed;
            {
                this.ctf = FileUtils.newTempFile(pom, true);
                this.failed = new AtomicBoolean(false);
            }

            @Override
            public void edit(ToolboxCommando.Editor editor) throws IOException {
                try {
                    editor.accept(this.ctf.getPath());
                }
                catch (IOException e) {
                    this.failed.set(true);
                    throw e;
                }
            }

            @Override
            public void close() throws IOException {
                if (!this.failed.get()) {
                    this.ctf.move();
                }
                this.ctf.close();
            }
        };
    }

    @Override
    public Result<List<Artifact>> editPom(ToolboxCommando.EditSession es, ToolboxCommando.PomOpSubject subject, ToolboxCommando.Op op, Source<Artifact> artifacts) throws Exception {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        es.edit(pom -> {
            try (PomTransformerSink sink = PomTransformerSink.transform(this.output, pom, subject, op);){
                List res = artifacts.get().collect(Collectors.toList());
                sink.accept(res);
                result.set(Result.success(res));
            }
        });
        return result.get();
    }

    @Override
    public Result<Boolean> editPom(ToolboxCommando.EditSession es, List<Consumer<SmartPomEditor>> transformers) throws Exception {
        es.edit(pom -> {
            SmartPomEditor smartPomEditor = new SmartPomEditor(new PomEditor(Document.of((Path)pom)));
            for (Consumer transformer : transformers) {
                transformer.accept(smartPomEditor);
            }
            Files.writeString(pom, (CharSequence)smartPomEditor.editor().toXml(), new OpenOption[0]);
        });
        return Result.success(true);
    }

    @Override
    public Path extensionsPath(ToolboxCommando.ExtensionsScope scope) {
        return switch (scope) {
            default -> throw new IncompatibleClassChangeError();
            case ToolboxCommando.ExtensionsScope.PROJECT -> throw new IllegalStateException("Project scope is not supported");
            case ToolboxCommando.ExtensionsScope.USER -> this.context.mavenUserHome().basedir().resolve("extensions.xml");
            case ToolboxCommando.ExtensionsScope.INSTALL -> this.context.mavenSystemHome().conf().resolve("extensions.xml");
        };
    }

    @Override
    public Result<List<Artifact>> listExtensions(Path extensions) throws Exception {
        Objects.requireNonNull(extensions, "extensions");
        if (Files.isRegularFile(extensions, new LinkOption[0])) {
            return Result.success(new SmartExtensionsEditor(new ExtensionsEditor(Document.of((Path)extensions))).listExtensions());
        }
        return Result.failure("File does not exists");
    }

    @Override
    public Result<List<Artifact>> editExtensions(ToolboxCommando.EditSession es, ToolboxCommando.Op op, Source<Artifact> artifacts) throws Exception {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        es.edit(pom -> {
            try (ExtensionsTransformerSink sink = ExtensionsTransformerSink.transform(this.output, pom, op);){
                List res = artifacts.get().collect(Collectors.toList());
                sink.accept(res);
                result.set(Result.success(res));
            }
        });
        return result.get();
    }

    public static String humanReadableByteCountBin(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.1f %ciB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }

    public static String discoverArtifactVersion(String groupId, String artifactId, String defVal) {
        Map<String, String> mavenPomProperties = ToolboxCommandoImpl.loadPomProperties(groupId, artifactId);
        String versionString = mavenPomProperties.getOrDefault("version", "").trim();
        if (!versionString.startsWith("${")) {
            return versionString;
        }
        return defVal;
    }

    public static Map<String, String> loadPomProperties(String groupId, String artifactId) {
        return ToolboxCommandoImpl.loadClasspathProperties("/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
    }

    public static Map<String, String> loadClasspathProperties(String resource) {
        Properties props = new Properties();
        try (InputStream is = RuntimeSupport.class.getResourceAsStream(resource);){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
    }

    public static Artifact source(Artifact artifact, boolean external) {
        return ToolboxCommandoImpl.addProperty(artifact, "source", external ? "external" : "internal");
    }

    public static Artifact origin(Artifact artifact, ArtifactRepository artifactRepository) {
        if (artifactRepository == null) {
            return artifact;
        }
        return ToolboxCommandoImpl.addProperty(artifact, "origin", artifactRepository.getId());
    }

    public static Artifact addProperty(Artifact artifact, String key, String value) {
        return ToolboxCommandoImpl.addProperties(artifact, Map.of(key, value));
    }

    public static Artifact addProperties(Artifact artifact, Map<String, String> properties) {
        HashMap<String, String> props = new HashMap<String, String>(artifact.getProperties());
        props.putAll(properties);
        return artifact.setProperties(props);
    }

    private static class InputLocationStringFormatter
    extends InputLocation.StringFormatter {
        private InputLocationStringFormatter() {
        }

        public String toString(InputLocation location) {
            InputSource source = location.getSource();
            String s = source.getModelId();
            if (s.trim().isBlank() || s.contains("[unknown-version]")) {
                s = source.toString();
            }
            return " " + s + (String)(location.getLineNumber() >= 0 ? ", line " + location.getLineNumber() : "") + " {";
        }
    }
}

