/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal.domtrip;

import eu.maveniverse.domtrip.Document;
import eu.maveniverse.domtrip.Element;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.maveniverse.domtrip.maven.PomEditor;

public final class DOMTripUtils {
    private DOMTripUtils() {
    }

    public static String textContent(Element element, String defaultValue) {
        if (element != null && element.textContent() != null) {
            return element.textContent();
        }
        return defaultValue;
    }

    public static String textContent(Element element) {
        return DOMTripUtils.textContent(element, null);
    }

    public static String optionalTextContentOfChild(Element element, String descendant, String defaultValue) {
        return DOMTripUtils.textContent(element.child(descendant).orElse(null), defaultValue);
    }

    public static String requiredTextContentOfChild(Element element, String descendant) {
        return DOMTripUtils.textContent((Element)element.child(descendant).orElseThrow());
    }

    public static String toGA(Element element) {
        Objects.requireNonNull(element);
        return DOMTripUtils.requiredTextContentOfChild(element, "groupId") + ":" + DOMTripUtils.requiredTextContentOfChild(element, "artifactId");
    }

    public static String toPluginGA(Element element) {
        Objects.requireNonNull(element);
        return DOMTripUtils.optionalTextContentOfChild(element, "groupId", "org.apache.maven.plugins") + ":" + DOMTripUtils.requiredTextContentOfChild(element, "artifactId");
    }

    public static String toGATC(Element element) {
        Objects.requireNonNull(element);
        String type = DOMTripUtils.optionalTextContentOfChild(element, "type", "jar");
        String classifier = DOMTripUtils.optionalTextContentOfChild(element, "classifier", null);
        if (classifier != null) {
            return DOMTripUtils.toGA(element) + ":" + type + ":" + classifier;
        }
        return DOMTripUtils.toGA(element) + ":" + type;
    }

    public static Predicate<Element> predicateGA(Artifact artifact) {
        Objects.requireNonNull(artifact);
        return element -> Objects.equals(DOMTripUtils.toGA(element), artifact.getGroupId() + ":" + artifact.getArtifactId());
    }

    public static Predicate<Element> predicatePluginGA(Artifact artifact) {
        Objects.requireNonNull(artifact);
        return element -> Objects.equals(DOMTripUtils.toPluginGA(element), artifact.getGroupId() + ":" + artifact.getArtifactId());
    }

    public static Predicate<Element> predicateGATC(Artifact artifact) {
        Objects.requireNonNull(artifact);
        return element -> Objects.equals(DOMTripUtils.toGATC(element), ArtifactIdUtils.toVersionlessId((Artifact)artifact));
    }

    public static Artifact gavToArtifact(Element element, String extension) {
        Objects.requireNonNull(element);
        return new DefaultArtifact(DOMTripUtils.requiredTextContentOfChild(element, "groupId"), DOMTripUtils.requiredTextContentOfChild(element, "artifactId"), extension, DOMTripUtils.requiredTextContentOfChild(element, "version"));
    }

    public static Artifact gavToJarArtifact(Element element) {
        return DOMTripUtils.gavToArtifact(element, "jar");
    }

    public static Artifact gavToPomArtifact(Element element) {
        return DOMTripUtils.gavToArtifact(element, "pom");
    }

    public static Artifact fromPom(Path pom) {
        Objects.requireNonNull(pom);
        PomEditor pomEditor = new PomEditor(Document.of((Path)pom));
        String groupId = DOMTripUtils.optionalTextContentOfChild(pomEditor.root(), "groupId", null);
        String artifactId = DOMTripUtils.requiredTextContentOfChild(pomEditor.root(), "artifactId");
        String version = DOMTripUtils.optionalTextContentOfChild(pomEditor.root(), "version", null);
        if (groupId == null || version == null) {
            Element parent = pomEditor.findChildElement(pomEditor.root(), "parent");
            if (parent != null) {
                if (groupId == null) {
                    groupId = DOMTripUtils.requiredTextContentOfChild(parent, "groupId");
                }
                if (version == null) {
                    version = DOMTripUtils.requiredTextContentOfChild(parent, "version");
                }
            } else {
                throw new IllegalArgumentException("Malformed POM: no groupId found");
            }
        }
        return new DefaultArtifact(groupId, artifactId, "pom", version).setFile(pom.toFile());
    }
}

