/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal.domtrip;

import eu.maveniverse.domtrip.Element;
import eu.maveniverse.maven.shared.core.component.ComponentSupport;
import eu.maveniverse.maven.toolbox.shared.internal.domtrip.DOMTripUtils;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.aether.artifact.Artifact;
import org.maveniverse.domtrip.maven.ExtensionsEditor;

public class SmartExtensionsEditor
extends ComponentSupport {
    private final ExtensionsEditor editor;

    public SmartExtensionsEditor(ExtensionsEditor editor) {
        this.editor = Objects.requireNonNull(editor);
        Objects.requireNonNull(editor.document());
    }

    public ExtensionsEditor editor() {
        return this.editor;
    }

    public List<Artifact> listExtensions() {
        return this.editor.root().children("extension").map(DOMTripUtils::gavToJarArtifact).toList();
    }

    public boolean updateExtension(boolean upsert, Artifact artifact) {
        Objects.requireNonNull(artifact);
        List<Element> matched = this.editor.root().children("extension").filter(DOMTripUtils.predicateGA(artifact)).toList();
        if (matched.isEmpty()) {
            if (upsert) {
                this.editor.addExtension(this.editor.root(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                return true;
            }
            return false;
        }
        Element element = matched.get(0);
        this.editor.findChildElement(element, "version").textContent(artifact.getVersion());
        if (matched.size() > 1) {
            this.logger.warn("More than one matching extension found: {}", (Object)matched.size());
        }
        return true;
    }

    public boolean deleteExtension(Artifact artifact) {
        Objects.requireNonNull(artifact);
        AtomicInteger counter = new AtomicInteger(0);
        this.editor.root().children("extension").filter(DOMTripUtils.predicateGA(artifact)).peek(e -> counter.incrementAndGet()).forEach(arg_0 -> ((ExtensionsEditor)this.editor).removeElement(arg_0));
        return counter.get() != 0;
    }
}

