/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.internal.domtrip;

import eu.maveniverse.domtrip.Element;
import eu.maveniverse.maven.shared.core.component.ComponentSupport;
import eu.maveniverse.maven.toolbox.shared.internal.domtrip.DOMTripUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.aether.artifact.Artifact;
import org.maveniverse.domtrip.maven.PomEditor;

public class SmartPomEditor
extends ComponentSupport {
    private final PomEditor editor;

    public SmartPomEditor(PomEditor editor) {
        this.editor = Objects.requireNonNull(editor);
        Objects.requireNonNull(editor.document());
    }

    public PomEditor editor() {
        return this.editor;
    }

    public boolean updateProperty(boolean upsert, String key, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Element properties = this.editor.root().child("properties").orElse(null);
        if (properties == null && upsert) {
            properties = this.editor.insertMavenElement(this.editor.root(), "properties");
        }
        if (properties != null) {
            Element property = properties.child(key).orElse(null);
            if (property == null && upsert) {
                property = this.editor.insertMavenElement(properties, key);
            }
            if (property != null) {
                property.textContent(value);
                return true;
            }
        }
        return false;
    }

    public boolean deleteProperty(String key) {
        Element property;
        Objects.requireNonNull(key);
        Element properties = this.editor.root().child("properties").orElse(null);
        if (properties != null && (property = (Element)properties.child(key).orElse(null)) != null) {
            this.editor.removeElement(property);
            return true;
        }
        return false;
    }

    public void setParent(Artifact artifact) {
        Objects.requireNonNull(artifact);
        Element parent = this.editor.findChildElement(this.editor.root(), "parent");
        if (parent == null) {
            parent = this.editor.insertMavenElement(this.editor.root(), "parent");
        }
        this.editor.insertMavenElement(parent, "groupId").textContent(artifact.getGroupId());
        this.editor.insertMavenElement(parent, "artifactId").textContent(artifact.getArtifactId());
        this.editor.insertMavenElement(parent, "version").textContent(artifact.getVersion());
    }

    public void setVersion(String value) {
        Element parent;
        Objects.requireNonNull(value);
        Element version = this.editor.findChildElement(this.editor.root(), "version");
        if (version == null && (parent = this.editor.findChildElement(this.editor.root(), "parent")) != null) {
            version = this.editor.findChildElement(parent, "version");
        }
        if (version != null) {
            version.textContent(value);
            return;
        }
        throw new IllegalArgumentException("Could not set version");
    }

    public void setPackaging(String value) {
        Objects.requireNonNull(value);
        Element packaging = this.editor.findChildElement(this.editor.root(), "packaging");
        if (packaging == null) {
            this.editor.insertMavenElement(this.editor.root(), "packaging", value);
        } else {
            packaging.textContent(value);
        }
    }

    public boolean addSubProject(String value) {
        List<String> existing;
        Objects.requireNonNull(value);
        Element modules = this.editor.findChildElement(this.editor.root(), "modules");
        if (modules == null) {
            modules = this.editor.insertMavenElement(this.editor.root(), "modules");
        }
        if (!(existing = modules.children("module").map(Element::textContent).toList()).contains(value)) {
            Element module = this.editor.insertMavenElement(modules, "module");
            module.textContent(value);
            return true;
        }
        return false;
    }

    public boolean removeSubProject(String value) {
        Objects.requireNonNull(value);
        Element modules = this.editor.findChildElement(this.editor.root(), "modules");
        if (modules == null) {
            return false;
        }
        AtomicBoolean removed = new AtomicBoolean(false);
        modules.children("module").filter(e -> Objects.equals(value, e.textContent())).peek(e -> removed.set(true)).forEach(arg_0 -> ((PomEditor)this.editor).removeElement(arg_0));
        return removed.get();
    }

    public boolean removePluginVersion(Artifact artifact) {
        Element pe;
        Element version;
        Optional<Element> plugin;
        Element plugins;
        Objects.requireNonNull(artifact);
        Element build = this.editor.findChildElement(this.editor.root(), "build");
        if (build != null && (plugins = this.editor.findChildElement(build, "plugins")) != null && (plugin = plugins.child("plugin").filter(DOMTripUtils.predicateGA(artifact)).stream().findFirst()).isPresent() && (version = this.editor.findChildElement(pe = plugin.orElseThrow(), "version")) != null) {
            this.editor.removeElement(version);
            return true;
        }
        return false;
    }

    public boolean updateManagedDependency(boolean upsert, Artifact artifact) {
        Objects.requireNonNull(artifact);
        Element dependencyManagement = this.editor.findChildElement(this.editor.root(), "dependencyManagement");
        if (dependencyManagement == null && upsert) {
            dependencyManagement = this.editor.insertMavenElement(this.editor.root(), "dependencyManagement");
        }
        if (dependencyManagement != null) {
            Element dependencies = this.editor.findChildElement(dependencyManagement, "dependencies");
            if (dependencies == null && upsert) {
                dependencies = this.editor.insertMavenElement(dependencyManagement, "dependencies");
            }
            if (dependencies != null) {
                Optional version;
                Element dependency = dependencies.children("dependency").filter(DOMTripUtils.predicateGATC(artifact)).findFirst().orElse(null);
                if (dependency == null && upsert) {
                    this.editor.addDependency(dependencies, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                    if (!"jar".equals(artifact.getExtension())) {
                        this.editor.insertMavenElement(dependency, "type", artifact.getExtension());
                    }
                    if (!artifact.getClassifier().trim().isEmpty()) {
                        this.editor.insertMavenElement(dependency, "classifier", artifact.getClassifier());
                    }
                    return true;
                }
                if (dependency != null && (version = dependency.child("version")).isPresent()) {
                    String versionValue = ((Element)version.orElseThrow()).textContent();
                    if (versionValue.startsWith("${") && versionValue.endsWith("}")) {
                        String propertyKey = versionValue.substring(2, versionValue.length() - 1);
                        return this.updateProperty(false, propertyKey, artifact.getVersion());
                    }
                    ((Element)version.orElseThrow()).textContent(artifact.getVersion());
                    return true;
                }
            }
        }
        return false;
    }

    public boolean deleteManagedDependency(Artifact artifact) {
        Element dependency;
        Element dependencies;
        Objects.requireNonNull(artifact);
        Element dependencyManagement = this.editor.findChildElement(this.editor.root(), "dependencyManagement");
        if (dependencyManagement != null && (dependencies = this.editor.findChildElement(dependencyManagement, "dependencies")) != null && (dependency = (Element)dependencies.children("dependency").filter(DOMTripUtils.predicateGATC(artifact)).findFirst().orElse(null)) != null) {
            return this.editor.removeElement(dependency);
        }
        return false;
    }

    public boolean updateDependency(boolean upsert, Artifact artifact) {
        Objects.requireNonNull(artifact);
        Element dependencies = this.editor.findChildElement(this.editor.root(), "dependencies");
        if (dependencies == null && upsert) {
            dependencies = this.editor.insertMavenElement(this.editor.root(), "dependencies");
        }
        if (dependencies != null) {
            Element dependency = dependencies.children("dependency").filter(DOMTripUtils.predicateGATC(artifact)).findFirst().orElse(null);
            if (dependency == null && upsert) {
                this.editor.addDependency(dependencies, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                if (!"jar".equals(artifact.getExtension())) {
                    this.editor.insertMavenElement(dependency, "type", artifact.getExtension());
                }
                if (!artifact.getClassifier().trim().isEmpty()) {
                    this.editor.insertMavenElement(dependency, "classifier", artifact.getClassifier());
                }
                return true;
            }
            if (dependency != null) {
                Optional version = dependency.child("version");
                if (version.isPresent()) {
                    String versionValue = ((Element)version.orElseThrow()).textContent();
                    if (versionValue.startsWith("${") && versionValue.endsWith("}")) {
                        String propertyKey = versionValue.substring(2, versionValue.length() - 1);
                        return this.updateProperty(false, propertyKey, artifact.getVersion());
                    }
                    ((Element)version.orElseThrow()).textContent(artifact.getVersion());
                    return true;
                }
                return this.updateManagedDependency(false, artifact);
            }
        }
        return false;
    }

    public boolean deleteDependency(Artifact artifact) {
        Element dependency;
        Objects.requireNonNull(artifact);
        Element dependencies = this.editor.findChildElement(this.editor.root(), "dependencies");
        if (dependencies != null && (dependency = (Element)dependencies.children("dependency").filter(DOMTripUtils.predicateGATC(artifact)).findFirst().orElse(null)) != null) {
            return this.editor.removeElement(dependency);
        }
        return false;
    }

    public boolean updateManagedPlugin(boolean upsert, Artifact artifact) {
        Objects.requireNonNull(artifact);
        Element build = this.editor.findChildElement(this.editor.root(), "build");
        if (build == null && upsert) {
            build = this.editor.insertMavenElement(this.editor.root(), "build");
        }
        if (build != null) {
            Element pluginManagement = this.editor.findChildElement(build, "pluginManagement");
            if (pluginManagement == null && upsert) {
                pluginManagement = this.editor.insertMavenElement(build, "pluginManagement");
            }
            if (pluginManagement != null) {
                Element plugins = this.editor.findChildElement(pluginManagement, "plugins");
                if (plugins == null && upsert) {
                    plugins = this.editor.insertMavenElement(pluginManagement, "plugins");
                }
                if (plugins != null) {
                    Optional version;
                    Element plugin = plugins.children("plugin").filter(DOMTripUtils.predicatePluginGA(artifact)).findFirst().orElse(null);
                    if (plugin == null && upsert) {
                        plugin = this.editor.insertMavenElement(plugins, "plugin");
                        this.editor.insertMavenElement(plugin, "groupId", artifact.getGroupId());
                        this.editor.insertMavenElement(plugin, "artifactId", artifact.getArtifactId());
                        this.editor.insertMavenElement(plugin, "version", artifact.getVersion());
                        return true;
                    }
                    if (plugin != null && (version = plugin.child("version")).isPresent()) {
                        String versionValue = ((Element)version.orElseThrow()).textContent();
                        if (versionValue.startsWith("${") && versionValue.endsWith("}")) {
                            String propertyKey = versionValue.substring(2, versionValue.length() - 1);
                            return this.updateProperty(false, propertyKey, artifact.getVersion());
                        }
                        ((Element)version.orElseThrow()).textContent(artifact.getVersion());
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean deleteManagedPlugin(Artifact artifact) {
        Element plugin;
        Element plugins;
        Element pluginManagement;
        Objects.requireNonNull(artifact);
        Element build = this.editor.findChildElement(this.editor.root(), "build");
        if (build != null && (pluginManagement = this.editor.findChildElement(build, "pluginManagement")) != null && (plugins = this.editor.findChildElement(pluginManagement, "plugins")) != null && (plugin = (Element)plugins.children("plugin").filter(DOMTripUtils.predicatePluginGA(artifact)).findFirst().orElse(null)) != null) {
            return this.editor.removeElement(plugin);
        }
        return false;
    }

    public boolean updatePlugin(boolean upsert, Artifact artifact) {
        Objects.requireNonNull(artifact);
        Element build = this.editor.findChildElement(this.editor.root(), "build");
        if (build == null && upsert) {
            build = this.editor.insertMavenElement(this.editor.root(), "build");
        }
        if (build != null) {
            Element plugins = this.editor.findChildElement(build, "plugins");
            if (plugins == null && upsert) {
                plugins = this.editor.insertMavenElement(build, "plugins");
            }
            if (plugins != null) {
                Element plugin = plugins.children("plugin").filter(DOMTripUtils.predicatePluginGA(artifact)).findFirst().orElse(null);
                if (plugin == null && upsert) {
                    this.editor.addPlugin(plugins, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                    return true;
                }
                if (plugin != null) {
                    Optional version = plugin.child("version");
                    if (version.isPresent()) {
                        String versionValue = ((Element)version.orElseThrow()).textContent();
                        if (versionValue.startsWith("${") && versionValue.endsWith("}")) {
                            String propertyKey = versionValue.substring(2, versionValue.length() - 1);
                            return this.updateProperty(false, propertyKey, artifact.getVersion());
                        }
                        ((Element)version.orElseThrow()).textContent(artifact.getVersion());
                        return true;
                    }
                    return this.updateManagedPlugin(upsert, artifact);
                }
            }
        }
        return false;
    }

    public boolean deletePlugin(Artifact artifact) {
        Element plugin;
        Element plugins;
        Objects.requireNonNull(artifact);
        Element build = this.editor.findChildElement(this.editor.root(), "build");
        if (build != null && (plugins = this.editor.findChildElement(build, "plugins")) != null && (plugin = (Element)plugins.children("plugin").filter(DOMTripUtils.predicatePluginGA(artifact)).findFirst().orElse(null)) != null) {
            return this.editor.removeElement(plugin);
        }
        return false;
    }

    public boolean updateExtension(boolean upsert, Artifact artifact) {
        Objects.requireNonNull(artifact);
        Element build = this.editor.findChildElement(this.editor.root(), "build");
        if (build == null && upsert) {
            build = this.editor.insertMavenElement(this.editor.root(), "build");
        }
        if (build != null) {
            Element extensions = this.editor.findChildElement(build, "extensions");
            if (extensions == null && upsert) {
                extensions = this.editor.insertMavenElement(build, "extensions");
            }
            if (extensions != null) {
                Optional version;
                Element extension = extensions.children("extension").filter(DOMTripUtils.predicateGA(artifact)).findFirst().orElse(null);
                if (extension == null && upsert) {
                    extension = this.editor.insertMavenElement(extensions, "extension");
                    this.editor.insertMavenElement(extension, "groupId", artifact.getGroupId());
                    this.editor.insertMavenElement(extension, "artifactId", artifact.getArtifactId());
                    this.editor.insertMavenElement(extension, "version", artifact.getVersion());
                    return true;
                }
                if (extension != null && (version = extension.child("version")).isPresent()) {
                    String versionValue = ((Element)version.orElseThrow()).textContent();
                    if (versionValue.startsWith("${") && versionValue.endsWith("}")) {
                        String propertyKey = versionValue.substring(2, versionValue.length() - 1);
                        return this.updateProperty(false, propertyKey, artifact.getVersion());
                    }
                    ((Element)version.orElseThrow()).textContent(artifact.getVersion());
                    return true;
                }
            }
        }
        return false;
    }

    public boolean deleteExtension(Artifact artifact) {
        Element extension;
        Element extensions;
        Objects.requireNonNull(artifact);
        Element build = this.editor.findChildElement(this.editor.root(), "build");
        if (build != null && (extensions = this.editor.findChildElement(build, "extensions")) != null && (extension = (Element)extensions.children("extension").filter(DOMTripUtils.predicateGA(artifact)).findFirst().orElse(null)) != null) {
            return this.editor.removeElement(extension);
        }
        return false;
    }

    public boolean updateParent(boolean upsert, Artifact artifact) {
        Objects.requireNonNull(artifact);
        Element parent = this.editor.findChildElement(this.editor.root(), "parent");
        if (parent == null && upsert) {
            parent = this.editor.insertMavenElement(this.editor.root(), "parent");
        }
        if (parent != null) {
            this.editor.insertMavenElement(parent, "groupId", artifact.getGroupId());
            this.editor.insertMavenElement(parent, "artifactId", artifact.getArtifactId());
            this.editor.insertMavenElement(parent, "version", artifact.getVersion());
            return true;
        }
        return false;
    }

    public boolean deleteParent() {
        Element parent = this.editor.findChildElement(this.editor.root(), "parent");
        if (parent != null) {
            this.editor.removeElement(parent);
            return true;
        }
        return false;
    }
}

