/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.output;

import eu.maveniverse.maven.toolbox.shared.output.Output;
import eu.maveniverse.maven.toolbox.shared.output.OutputSupport;
import java.util.Arrays;
import org.slf4j.Logger;

public final class LoggerOutput
extends OutputSupport {
    private final Logger output;

    public LoggerOutput(Logger output, boolean errors, Output.Verbosity verbosity) {
        super(verbosity, errors);
        this.output = output;
    }

    @Override
    public void warn(String message, Object ... params) {
        if (!this.isShowErrors() && params.length > 0 && params[params.length - 1] instanceof Throwable) {
            this.output.warn(message + " " + ((Throwable)params[params.length - 1]).getMessage(), Arrays.copyOf(params, params.length - 1));
        } else {
            this.output.warn(message, params);
        }
    }

    @Override
    public void error(String message, Object ... params) {
        if (!this.isShowErrors() && params.length > 0 && params[params.length - 1] instanceof Throwable) {
            this.output.error(message + " " + ((Throwable)params[params.length - 1]).getMessage(), Arrays.copyOf(params, params.length - 1));
        } else {
            this.output.error(message, params);
        }
    }

    @Override
    protected void doHandle(Output.Verbosity verbosity, String message, Object ... params) {
        this.output.info(message, params);
    }
}

