/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.shared.output;

import eu.maveniverse.maven.toolbox.shared.output.Marker;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class OutputSupport
implements Output {
    protected final Output.Verbosity verbosity;
    protected final boolean errors;

    public OutputSupport(Output.Verbosity verbosity, boolean errors) {
        this.verbosity = Objects.requireNonNull(verbosity, "verbosity");
        this.errors = errors;
    }

    @Override
    public Output.Verbosity getVerbosity() {
        return this.verbosity;
    }

    @Override
    public boolean isShowErrors() {
        return this.errors;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public <T> T tool(Class<? extends T> klazz, Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        return supplier.get();
    }

    @Override
    public Marker marker(Output.Verbosity verbosity) {
        return new Marker(this, verbosity);
    }

    @Override
    public boolean isHeard(Output.Verbosity verbosity) {
        Objects.requireNonNull(verbosity);
        return this.getVerbosity().ordinal() >= verbosity.ordinal();
    }

    @Override
    public void doTell(String message, Object ... params) {
        if (this.isHeard(Output.Verbosity.TIGHT)) {
            this.handle(Output.Verbosity.TIGHT, message, params);
        }
    }

    @Override
    public void tell(String message, Object ... params) {
        if (this.isHeard(Output.Verbosity.NORMAL)) {
            this.handle(Output.Verbosity.NORMAL, message, params);
        }
    }

    @Override
    public void suggest(String message, Object ... params) {
        if (this.isHeard(Output.Verbosity.SUGGEST)) {
            this.handle(Output.Verbosity.SUGGEST, message, params);
        }
    }

    @Override
    public void chatter(String message, Object ... params) {
        if (this.isHeard(Output.Verbosity.CHATTER)) {
            this.handle(Output.Verbosity.CHATTER, message, params);
        }
    }

    @Override
    public void warn(String message, Object ... params) {
        new Marker(this, Output.Verbosity.TIGHT).scary("[W] " + message).say(params);
    }

    @Override
    public void error(String message, Object ... params) {
        new Marker(this, Output.Verbosity.TIGHT).bloody("[E] " + message).say(params);
    }

    @Override
    public void handle(Output.Verbosity verbosity, String message, Object ... params) {
        if (this.isHeard(verbosity)) {
            this.doHandle(verbosity, message, params);
        }
    }

    protected abstract void doHandle(Output.Verbosity var1, String var2, Object ... var3);
}

